/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;

public final class FixResizeCursorSupport
implements AWTEventListener {
    private static FixResizeCursorSupport listener;

    private FixResizeCursorSupport() {
    }

    public static void install() {
        if (listener != null) {
            return;
        }
        listener = new FixResizeCursorSupport();
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 16L);
    }

    public static void uninstall() {
        if (listener == null) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        listener = null;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501) {
            Window[] windowArray = Window.getWindows();
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window w = windowArray[n2];
                if (!w.isVisible()) {
                    return;
                }
                Cursor c = w.getCursor();
                if (c != null) {
                    switch (c.getType()) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            w.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

