/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;

public class HyperlinkBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private static Insets borderInsets = new Insets(1, 3, 1, 3);
    private static final Color DEFAULT_LINE_COLOR = new Color(68, 85, 153);

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = HyperlinkBorder.borderInsets.top;
        insets.left = HyperlinkBorder.borderInsets.left;
        insets.bottom = HyperlinkBorder.borderInsets.bottom;
        insets.right = HyperlinkBorder.borderInsets.right;
        return insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        JLabel label = (JLabel)c;
        Rectangle viewR = new Rectangle(HyperlinkBorder.borderInsets.left, HyperlinkBorder.borderInsets.top, c.getWidth() - HyperlinkBorder.borderInsets.left - HyperlinkBorder.borderInsets.right, c.getHeight() - HyperlinkBorder.borderInsets.top - HyperlinkBorder.borderInsets.bottom);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        FontMetrics fm = label.getFontMetrics(label.getFont());
        SwingUtilities.layoutCompoundLabel(label, fm, label.getText(), label.getIcon(), label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        x = textR.x;
        y = textR.y;
        w = textR.width;
        h = textR.height;
        g.setColor(this.getForegroundColor(c));
        if (!StringUtility.isNullOrEmpty((CharSequence)label.getText())) {
            if (c.isEnabled() && c.isFocusOwner()) {
                HyperlinkBorder.drawFocus(g, x - 1, y, w + 2, h);
            }
            if (c.isEnabled() && c.getMousePosition() != null) {
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        }
    }

    private Color getForegroundColor(Component c) {
        if (c.getForeground() instanceof ColorUIResource) {
            Color defaultLineColor = UIManager.getDefaults().getColor("Hyperlink.foreground");
            if (defaultLineColor == null) {
                defaultLineColor = DEFAULT_LINE_COLOR;
            }
            return defaultLineColor;
        }
        return c.getForeground();
    }

    private static void drawFocus(Graphics g, int x, int y, int w, int h) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke old = g2d.getStroke();
        float pattern0 = ((Float)NumberUtility.nvl((Object)((Float)TypeCastUtility.castValue((Object)UIManager.getLookAndFeelDefaults().get("Hyperlink.borderPattern0"), Float.class)), (Object)Float.valueOf(1.0f))).floatValue();
        float pattern1 = ((Float)NumberUtility.nvl((Object)((Float)TypeCastUtility.castValue((Object)UIManager.getLookAndFeelDefaults().get("Hyperlink.borderPattern1"), Float.class)), (Object)Float.valueOf(2.0f))).floatValue();
        g2d.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{pattern0, pattern1}, 1.0f));
        g2d.drawLine(x, y, x + w - 1, y);
        g2d.drawLine(x, y + h, x + w - 1, y + h);
        g2d.drawLine(x, y, x, y + h - 1);
        g2d.drawLine(x + w, y, x + w, y + h - 1);
        g2d.setStroke(old);
    }
}

