/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.datefield;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.document.BasicDocumentFilter;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DropDownDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.datefield.ISwingScoutDateField;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutDropDownPopup;

public class SwingScoutDateField
extends SwingScoutBasicFieldComposite<IDateField>
implements ISwingScoutDateField {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutDateField.class);
    private boolean m_ignoreLabel;
    private boolean m_dateTimeCompositeMember;
    private String m_displayTextToVerify;
    private SwingScoutDropDownPopup m_proposalPopup;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private DropDownDecorationItem m_dropdownIcon;
    private SwingScoutContextMenu m_contextMenu;
    private PropertyChangeListener m_contextMenuVisibilityListener;

    public boolean isIgnoreLabel() {
        return this.m_ignoreLabel;
    }

    public void setIgnoreLabel(boolean ignoreLabel) {
        this.m_ignoreLabel = ignoreLabel;
    }

    public boolean isDateTimeCompositeMember() {
        return this.m_dateTimeCompositeMember;
    }

    public void setDateTimeCompositeMember(boolean dateTimeCompositeMember) {
        this.m_dateTimeCompositeMember = dateTimeCompositeMember;
    }

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        if (!this.isIgnoreLabel()) {
            JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
            container.add(label);
            this.setSwingLabel(label);
        }
        JTextFieldWithDecorationIcons dateField = this.createDateField(container);
        Document doc = dateField.getDocument();
        this.addInputListenersForBasicField(dateField, doc);
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new BasicDocumentFilter(60));
        }
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutDateField.this.setInputDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutDateField.this.setInputDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutDateField.this.setInputDirty(true);
            }
        });
        container.add(dateField);
        InputMap inputMap = dateField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "dateChooser");
        inputMap.put(SwingUtility.createKeystroke("UP"), "nextDay");
        inputMap.put(SwingUtility.createKeystroke("DOWN"), "prevDay");
        inputMap.put(SwingUtility.createKeystroke("shift UP"), "nextMonth");
        inputMap.put(SwingUtility.createKeystroke("shift DOWN"), "prevMonth");
        inputMap.put(SwingUtility.createKeystroke("ctrl UP"), "nextYear");
        inputMap.put(SwingUtility.createKeystroke("ctrl DOWN"), "prevYear");
        ActionMap actionMap = dateField.getActionMap();
        actionMap.put("dateChooser", new P_SwingDateChooserAction());
        actionMap.put("nextDay", new P_SwingDateShiftAction(0, 1));
        actionMap.put("prevDay", new P_SwingDateShiftAction(0, -1));
        actionMap.put("nextMonth", new P_SwingDateShiftAction(1, 1));
        actionMap.put("prevMonth", new P_SwingDateShiftAction(1, -1));
        actionMap.put("nextYear", new P_SwingDateShiftAction(2, 1));
        actionMap.put("prevYear", new P_SwingDateShiftAction(2, -1));
        this.setSwingContainer(container);
        this.setSwingField(dateField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JTextFieldWithDecorationIcons createDateField(JComponent container) {
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        this.initializeDateField(textField);
        container.add(textField);
        return textField;
    }

    protected void initializeDateField(JTextFieldWithDecorationIcons textField) {
        textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTextFieldWithDecorationIcons text = (JTextFieldWithDecorationIcons)e.getComponent();
                if (text.getRegion(e.getPoint()) == JTextFieldWithDecorationIcons.Region.Text && e.getButton() == 1) {
                    SwingScoutDateField.this.handleSwingDateChooserAction();
                }
            }
        });
        DecorationGroup decorationGroup = new DecorationGroup(textField, this.getSwingEnvironment());
        this.m_contextMenuMarker = new ContextMenuDecorationItem((IContextMenu)((IDateField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutDateField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        decorationGroup.addDecoration(this.m_contextMenuMarker);
        this.m_dropdownIcon = new DropDownDecorationItem(textField, this.getSwingEnvironment());
        this.m_dropdownIcon.setIconGroup(new IconGroup(this.getSwingEnvironment(), "datefield_date"));
        this.m_dropdownIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    SwingScoutDateField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
                } else {
                    SwingScoutDateField.this.getSwingDateField().requestFocus();
                    SwingScoutDateField.this.handleSwingDateChooserAction();
                }
            }
        });
        decorationGroup.addDecoration(this.m_dropdownIcon);
        textField.setDecorationIcon(decorationGroup);
    }

    protected void installContextMenu() {
        this.m_contextMenuVisibilityListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutDateField.this.m_contextMenuMarker.setMarkerVisible(((IDateField)SwingScoutDateField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        };
        ((IDateField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(this.m_contextMenuVisibilityListener);
        this.m_contextMenuMarker.setMarkerVisible(((IDateField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingDateField(), (IContextMenu)((IDateField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    protected void uninstallContextMenu() {
        if (this.m_contextMenuVisibilityListener != null) {
            ((IDateField)this.getScoutObject()).getContextMenu().removePropertyChangeListener(this.m_contextMenuVisibilityListener);
            this.m_contextMenuVisibilityListener = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.installContextMenu();
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuMarker != null) {
            this.m_contextMenuMarker.destroy();
        }
        this.uninstallContextMenu();
        super.detachScout();
    }

    public JTextFieldWithDecorationIcons getSwingDateField() {
        return (JTextFieldWithDecorationIcons)this.getSwingField();
    }

    public DropDownDecorationItem getDropdownIcon() {
        return this.m_dropdownIcon;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dropdownIcon.setEnabled(b);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingDateField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        JTextComponent swingField = this.getSwingField();
        String oldText = swingField.getText();
        if (s == null) {
            s = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(s)) {
            return;
        }
        this.m_displayTextToVerify = s;
        IDateField f = (IDateField)this.getScoutObject();
        Date value = (Date)f.getValue();
        if (f.isHasTime() && value != null) {
            DateFormat format = f.getIsolatedDateFormat();
            this.m_displayTextToVerify = format.format(value);
        }
        this.updateTextKeepCurserPosition(this.m_displayTextToVerify);
    }

    @Override
    protected boolean handleSwingInputVerifier() {
        final String text = this.getSwingDateField().getText();
        if (!this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown && CompareUtility.equals((Object)text, (Object)this.m_displayTextToVerify) && (this.isDateTimeCompositeMember() || ((IDateField)this.getScoutObject()).getErrorStatus() == null)) {
            return true;
        }
        this.m_displayTextToVerify = text;
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)SwingScoutDateField.this.getScoutObject()).getUIFacade().setDateTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        if (this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown && !this.m_updateDisplayTextOnModify) {
            this.m_updateDisplayTextOnModifyWasTrueSinceLastWriteDown = false;
        }
        return true;
    }

    private void acceptProposalFromSwing(final Date newDate) {
        this.closePopup();
        if (newDate != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IDateField)SwingScoutDateField.this.getScoutObject()).getUIFacade().setDateFromUI(newDate);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private void closePopup() {
        if (this.m_proposalPopup != null) {
            this.m_proposalPopup.closeView();
            this.m_proposalPopup = null;
            this.getSwingDateField().getInputMap(0).remove(SwingUtility.createKeystroke("ENTER"));
            this.getSwingDateField().getInputMap(0).remove(SwingUtility.createKeystroke("ESCAPE"));
        }
    }

    protected boolean isDateChooserEnabled() {
        return this.getSwingDateField() != null && this.getSwingDateField().isEditable();
    }

    protected void handleSwingDateChooserAction() {
        this.closePopup();
        if (this.isDateChooserEnabled()) {
            Date d = (Date)((IDateField)this.getScoutObject()).getValue();
            if (d == null) {
                d = new Date();
            }
            final DateChooser dateChooser = new DateChooser();
            dateChooser.setDate(d);
            dateChooser.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SwingScoutDateField.this.acceptProposalFromSwing(dateChooser.getDate());
                }
            });
            JPanel popupContent = dateChooser.getContainer();
            AbstractAction acceptAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutDateField.this.closePopup();
                    SwingScoutDateField.this.handleSwingInputVerifier();
                }
            };
            AbstractAction escAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutDateField.this.closePopup();
                }
            };
            JTextFieldWithDecorationIcons textField = this.getSwingDateField();
            textField.getInputMap(0).put(SwingUtility.createKeystroke("ENTER"), "enter");
            textField.getActionMap().put("enter", acceptAction);
            textField.getInputMap(0).put(SwingUtility.createKeystroke("ESCAPE"), "escape");
            textField.getActionMap().put("escape", escAction);
            popupContent.getInputMap(1).put(SwingUtility.createKeystroke("ENTER"), "enter");
            popupContent.getActionMap().put("enter", acceptAction);
            popupContent.getInputMap(1).put(SwingUtility.createKeystroke("ESCAPE"), "escape");
            popupContent.getActionMap().put("escape", escAction);
            this.m_proposalPopup = new SwingScoutDropDownPopup(this.getSwingEnvironment(), (Component)textField, textField);
            this.m_proposalPopup.makeNonFocusable();
            this.m_proposalPopup.addSwingScoutViewListener(new SwingScoutViewListener(){

                @Override
                public void viewChanged(SwingScoutViewEvent e) {
                    if (e.getType() == 40) {
                        SwingScoutDateField.this.closePopup();
                    }
                }
            });
            this.m_proposalPopup.getSwingContentPane().add(popupContent);
            this.m_proposalPopup.openView();
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        JTextComponent fld = this.getSwingField();
        if (fld != null && scoutColor != null && fld instanceof JTextComponent) {
            this.setDisabledTextColor(ColorUtility.createColor(scoutColor), fld);
        }
        super.setForegroundFromScout(scoutColor);
    }

    @Override
    protected void setSelectionFromSwing() {
    }

    @Override
    protected boolean isSelectAllOnFocusInScout() {
        return true;
    }

    private class P_SwingDateChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingDateChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutDateField.this.handleSwingDateChooserAction();
        }
    }

    private class P_SwingDateShiftAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int m_level;
        private int m_value;

        public P_SwingDateShiftAction(int level, int value) {
            this.m_level = level;
            this.m_value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutDateField.this.closePopup();
            if (SwingScoutDateField.this.getSwingDateField().isVisible() && SwingScoutDateField.this.getSwingDateField().isEditable()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        String newDisplayText = SwingScoutDateField.this.getSwingDateField().getText();
                        if (!CompareUtility.equals((Object)newDisplayText, (Object)((IDateField)SwingScoutDateField.this.getScoutObject()).getDisplayText())) {
                            ((IDateField)SwingScoutDateField.this.getScoutObject()).getUIFacade().setDateTextFromUI(newDisplayText);
                        }
                        ((IDateField)SwingScoutDateField.this.getScoutObject()).getUIFacade().fireDateShiftActionFromUI(P_SwingDateShiftAction.this.m_level, P_SwingDateShiftAction.this.m_value);
                    }
                };
                SwingScoutDateField.this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }
}

