/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.groupbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JSection;
import org.eclipse.scout.rt.ui.swing.ext.ViewportTrackableJScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.BackgroundBorder;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.ISwingScoutGroupBox;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.SwingScoutGroupBoxButtonbar;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.TitledGroupBorder;

public class SwingScoutGroupBox
extends SwingScoutFieldComposite<IGroupBox>
implements ISwingScoutGroupBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutGroupBox.class);
    private JPanel m_swingBodyPart;
    private JPanel m_swingButtonBarPart;
    protected String m_containerLabel;
    protected String m_containerImage;
    protected int m_containerImageHAlign = 2;
    protected int m_containerImageVAlign = 1;
    protected boolean m_containerBorderInstalled;
    protected boolean m_containerBorderVisible;
    protected String m_containerBorderDecoration;

    @Override
    protected void initializeSwing() {
        this.m_swingBodyPart = new JPanelEx();
        this.m_swingBodyPart.setName("Synth.GroupBoxBody");
        this.m_swingBodyPart.setOpaque(false);
        this.m_swingBodyPart.putClientProperty("groupBoxMarker", Boolean.TRUE);
        this.m_swingButtonBarPart = this.createButtonBarPart();
        JPanelEx swingBox = new JPanelEx();
        swingBox.setOpaque(false);
        swingBox.setLayout(new BorderLayoutEx(0, 0));
        if (((IGroupBox)this.getScoutObject()).isScrollable()) {
            ViewportTrackableJScrollPaneEx scrollPane = new ViewportTrackableJScrollPaneEx(this.m_swingBodyPart);
            scrollPane.setBorder(null);
            int hScrollIncrement = 16;
            JScrollBar hsb = scrollPane.getHorizontalScrollBar();
            hsb.setUnitIncrement(hScrollIncrement);
            hsb.setBlockIncrement(hScrollIncrement);
            int vScrollIncrement = this.getSwingEnvironment().getFormRowHeight() + this.getSwingEnvironment().getFormRowGap();
            JScrollBar vsb = scrollPane.getVerticalScrollBar();
            vsb.setUnitIncrement(vScrollIncrement);
            vsb.setBlockIncrement(vScrollIncrement);
            swingBox.add((Component)scrollPane, "Center");
        } else {
            swingBox.add((Component)this.m_swingBodyPart, "Center");
        }
        swingBox.add((Component)this.m_swingButtonBarPart, "South");
        this.interceptBorderStyle((IGroupBox)this.getScoutObject());
        if (this.isSection()) {
            JSection section = new JSection(swingBox);
            section.setExpandable(((IGroupBox)this.getScoutObject()).isExpandable());
            this.setSwingField(section);
            this.setSwingLabel(null);
            this.setSwingContainer(section);
        } else {
            this.setSwingField(swingBox);
            this.setSwingLabel(null);
            this.setSwingContainer(swingBox);
        }
        LogicalGridLayout bodyLayout = new LogicalGridLayout(this.getSwingEnvironment(), this.getSwingEnvironment().getFormColumnGap(), this.getSwingEnvironment().getFormRowGap(), false);
        this.m_swingBodyPart.setLayout(bodyLayout);
        for (IFormField field : ((IGroupBox)this.getScoutObject()).getControlFields()) {
            ISwingScoutFormField swingScoutComposite = this.getSwingEnvironment().createFormField(this.m_swingBodyPart, field);
            SwingScoutFormFieldGridData cons = new SwingScoutFormFieldGridData(field);
            swingScoutComposite.getSwingContainer().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, cons);
            this.m_swingBodyPart.add(swingScoutComposite.getSwingContainer());
        }
    }

    protected boolean isSection() {
        return this.m_containerBorderVisible && "section".equals(this.m_containerBorderDecoration);
    }

    protected JPanel createButtonBarPart() {
        SwingScoutGroupBoxButtonbar swingScoutGroupBoxButtonbar = new SwingScoutGroupBoxButtonbar();
        swingScoutGroupBoxButtonbar.createField((IGroupBox)this.getScoutObject(), this.getSwingEnvironment());
        return swingScoutGroupBoxButtonbar.getSwingContainer();
    }

    @Override
    public JPanel getSwingGroupBox() {
        return (JPanel)this.getSwingField();
    }

    @Override
    public JPanel getSwingBodyPart() {
        return this.m_swingBodyPart;
    }

    @Override
    public JPanel getSwingButtonBarPart() {
        return this.m_swingButtonBarPart;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IGroupBox scoutGroupBox = (IGroupBox)this.getScoutObject();
        this.setBackgroundImageFromScout(scoutGroupBox.getBackgroundImageName());
        this.setBackgroundImageHorizontalAlignFromScout(scoutGroupBox.getBackgroundImageHorizontalAlignment());
        this.setBackgroundImageVerticalAlignFromScout(scoutGroupBox.getBackgroundImageVerticalAlignment());
        this.setExpandedFromScout();
        this.setEnabledFromScout(scoutGroupBox.isEnabled());
        this.changeContainerLabel();
        this.installSwingContainerBorder();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        if (b) {
            this.getSwingGroupBox().setForeground(null);
        } else {
            Color color = UIManager.getColor("textInactiveText");
            this.getSwingGroupBox().setForeground(color);
        }
    }

    @Override
    protected void setLabelVisibleFromScout() {
        super.setLabelVisibleFromScout();
        this.changeContainerLabel();
    }

    @Override
    protected void setLabelFromScout(String s) {
        super.setLabelFromScout(s);
        this.changeContainerLabel();
    }

    protected void setExpandedFromScout() {
        if (this.getSwingContainer() instanceof JSection) {
            JSection section = (JSection)this.getSwingContainer();
            section.setExpanded(((IGroupBox)this.getScoutObject()).isExpanded());
        }
    }

    protected void interceptBorderStyle(IGroupBox box) {
        this.m_containerBorderVisible = box.isBorderVisible();
        this.m_containerBorderDecoration = "empty";
        if (this.m_containerBorderVisible) {
            if ("section".equals(box.getBorderDecoration())) {
                this.m_containerBorderDecoration = "section";
            } else if ("line".equals(box.getBorderDecoration())) {
                this.m_containerBorderDecoration = "line";
            } else if ("auto".equals(box.getBorderDecoration())) {
                if (box.isMainBox()) {
                    if (SwingUtility.isSynth()) {
                        this.m_containerBorderVisible = false;
                    }
                    this.m_containerBorderDecoration = "empty";
                } else {
                    this.m_containerBorderDecoration = box.isExpandable() ? "section" : (box.getParentField() instanceof ITabBox ? "empty" : "line");
                }
            }
        }
    }

    protected void setBackgroundImageFromScout(String imageName) {
        if (!(imageName == this.m_containerImage || imageName != null && imageName.equals(this.m_containerImage))) {
            this.m_containerImage = imageName;
            if (this.m_containerBorderInstalled) {
                this.installSwingContainerBorder();
            }
        }
    }

    protected void setBackgroundImageHorizontalAlignFromScout(int halign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(halign);
        if (swingAlign != this.m_containerImageHAlign) {
            this.m_containerImageHAlign = swingAlign;
            if (this.m_containerBorderInstalled) {
                this.installSwingContainerBorder();
            }
        }
    }

    protected void setBackgroundImageVerticalAlignFromScout(int valign) {
        int swingAlign = SwingUtility.createVerticalAlignment(valign);
        if (swingAlign != this.m_containerImageVAlign) {
            this.m_containerImageVAlign = swingAlign;
            if (this.m_containerBorderInstalled) {
                this.installSwingContainerBorder();
            }
        }
    }

    protected void changeContainerLabel() {
        String s;
        String string = s = ((IGroupBox)this.getScoutObject()).isLabelVisible() ? ((IGroupBox)this.getScoutObject()).getLabel() : null;
        if (s == null) {
            s = "";
        }
        if (!s.equals(this.m_containerLabel)) {
            this.m_containerLabel = s;
            if (this.m_containerBorderInstalled) {
                this.installSwingContainerBorder();
            }
        }
    }

    protected void installSwingContainerBorder() {
        this.m_containerBorderInstalled = true;
        if (this.m_containerBorderVisible) {
            Insets insets;
            Border border = UIManager.getBorder("GroupBox.border");
            if (border == null) {
                border = new EmptyBorder(0, 0, 0, 0);
            }
            if (((IGroupBox)this.getScoutObject()).isMainBox()) {
                insets = border.getBorderInsets(null);
                insets.left += 6;
                insets.right += 6;
                border = new EmptyBorder(insets);
            }
            if ("section".equals(this.m_containerBorderDecoration)) {
                JSection section = (JSection)this.getSwingContainer();
                section.setText(this.m_containerLabel);
                section.addPropertyChangeListener("expanded", new P_ExpansionListener());
                section.getContentPane().setBorder(border);
            } else if ("line".equals(this.m_containerBorderDecoration)) {
                AbstractBorder bgBorder;
                insets = new Insets(26, border.getBorderInsets(null).left, border.getBorderInsets(null).bottom, border.getBorderInsets(null).right);
                insets.bottom += 6;
                insets.right += 6;
                border = new TitledGroupBorder(this.m_containerLabel != null ? this.m_containerLabel : "", insets);
                if (this.m_containerImage != null) {
                    Icon icon = this.getSwingEnvironment().getIcon(this.m_containerImage);
                    if (icon != null) {
                        this.getSwingContainer().setMinimumSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                    } else {
                        this.getSwingContainer().setMinimumSize(null);
                    }
                    bgBorder = new BackgroundBorder(icon, this.m_containerImageHAlign, this.m_containerImageVAlign);
                } else {
                    bgBorder = new EmptyBorder(0, 0, 0, 0);
                }
                this.getSwingContainer().setBorder(new CompoundBorder(border, bgBorder));
            } else {
                this.getSwingContainer().setBorder(border);
            }
        } else {
            this.getSwingContainer().setBorder(null);
            this.getSwingBodyPart().setName(null);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        IGroupBox gb = (IGroupBox)this.getScoutObject();
        if (name.equals("expanded")) {
            this.setExpandedFromScout();
        } else if (name.equals("backgroundImageName")) {
            this.setBackgroundImageFromScout(gb.getBackgroundImageName());
        } else if (name.equals("backgroundImageHorizontalAlignment")) {
            this.setBackgroundImageHorizontalAlignFromScout(gb.getBackgroundImageHorizontalAlignment());
        } else if (name.equals("backgroundImageVerticalAlignment")) {
            this.setBackgroundImageVerticalAlignFromScout(gb.getBackgroundImageVerticalAlignment());
        }
    }

    protected void handleSwingGroupBoxExpanded(final boolean expanded) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IGroupBox)SwingScoutGroupBox.this.getScoutObject()).getUIFacade().setExpandedFromUI(expanded);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_ExpansionListener
    implements PropertyChangeListener {
        private P_ExpansionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("expanded".equals(evt.getPropertyName()) && evt.getNewValue() != null) {
                SwingScoutGroupBox.this.handleSwingGroupBoxExpanded((Boolean)evt.getNewValue());
            }
        }
    }
}

