/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.numberfield;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.numberfield.ISwingScoutNumberField;

public class SwingScoutNumberField
extends SwingScoutBasicFieldComposite<INumberField<?>>
implements ISwingScoutNumberField {
    private static final long serialVersionUID = 1L;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;
    private PropertyChangeListener m_contextMenuVisibilityListener;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        this.m_contextMenuMarker = new ContextMenuDecorationItem((IContextMenu)((INumberField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutNumberField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        textField.setDecorationIcon(this.m_contextMenuMarker);
        Document doc = textField.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new P_DocumentFilter());
        }
        this.addInputListenersForBasicField(textField, doc);
        container.add(textField);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected void installContextMenu() {
        this.m_contextMenuVisibilityListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutNumberField.this.m_contextMenuMarker.setMarkerVisible(((INumberField)SwingScoutNumberField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        };
        ((INumberField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(this.m_contextMenuVisibilityListener);
        this.m_contextMenuMarker.setMarkerVisible(((INumberField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingTextField(), (IContextMenu)((INumberField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    protected void uninstallContextMenu() {
        if (this.m_contextMenuVisibilityListener != null) {
            ((INumberField)this.getScoutObject()).getContextMenu().removePropertyChangeListener(this.m_contextMenuVisibilityListener);
            this.m_contextMenuVisibilityListener = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.installContextMenu();
    }

    @Override
    protected void detachScout() {
        if (this.m_contextMenuMarker != null) {
            this.m_contextMenuMarker.destroy();
        }
        this.uninstallContextMenu();
        super.detachScout();
    }

    @Override
    public JTextField getSwingTextField() {
        return (JTextField)this.getSwingField();
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        JTextComponent fld = this.getSwingField();
        if (fld != null && scoutColor != null && fld instanceof JTextComponent) {
            this.setDisabledTextColor(ColorUtility.createColor(scoutColor), fld);
        }
        super.setForegroundFromScout(scoutColor);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingTextField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void setSelectionFromSwing() {
    }

    @Override
    protected boolean isSelectAllOnFocusInScout() {
        return true;
    }

    private boolean textWasPasted(String text) {
        return StringUtility.length((CharSequence)text) > 1;
    }

    private final class P_DocumentFilter
    extends DocumentFilter {
        private P_DocumentFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            if (AbstractNumberField.isWithinNumberFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)length, (String)text)) {
                super.replace(fb, offset, length, text, attrs);
            } else if (SwingScoutNumberField.this.textWasPasted(text)) {
                try {
                    text = AbstractNumberField.createNumberWithinFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)length, (String)text);
                    offset = 0;
                    length = doc.getLength();
                    super.replace(fb, offset, length, text, attrs);
                }
                catch (ProcessingException e) {
                    this.showCouldNotPasteDialog();
                }
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            if (SwingScoutNumberField.this.textWasPasted(text)) {
                try {
                    text = AbstractNumberField.createNumberWithinFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)0, (String)text);
                    super.insertString(fb, offset, text, attr);
                }
                catch (ProcessingException e) {
                    this.showCouldNotPasteDialog();
                }
            } else if (AbstractNumberField.isWithinNumberFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)0, (String)text)) {
                super.insertString(fb, offset, text, attr);
            }
        }

        private void showCouldNotPasteDialog() {
            SwingUtility.showMessageDialogSynthCapable(SwingUtility.getOwnerForChildWindow(), SwingUtility.getNlsText("PasteTextNotApplicableForNumberField", String.valueOf(((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat().getMaximumIntegerDigits())), SwingUtility.getNlsText("Paste", new String[0]), 2);
        }
    }
}

