/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JWindowEx;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;
import org.eclipse.scout.rt.ui.swing.window.DependentCloseListener;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;

public class SwingScoutPopup
implements ISwingScoutView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutPopup.class);
    private final ISwingEnvironment m_env;
    private final EventListenerList m_listenerList;
    private final Component m_ownerComponent;
    private ComponentListener m_ownerComponentListener;
    private final Rectangle m_ownerBounds;
    private final JWindowEx m_swingWindow;
    private boolean m_resizable;
    private final P_ResizeListener m_resizeListener;
    private boolean m_maximized;
    private boolean m_positionBelowReferenceField;
    private Rectangle m_boundsBeforeMaximize;
    private boolean m_opened;
    private boolean m_closeFired;
    private int m_fixedWidth;
    private boolean m_popupOnField;

    public SwingScoutPopup(ISwingEnvironment env, Component ownerComponent, Rectangle ownerBounds) {
        this.m_env = env;
        this.m_ownerComponent = ownerComponent;
        this.m_ownerBounds = ownerBounds;
        this.m_listenerList = new EventListenerList();
        this.m_positionBelowReferenceField = true;
        this.m_resizeListener = new P_ResizeListener();
        Window w = SwingUtilities.getWindowAncestor(this.m_ownerComponent);
        this.m_swingWindow = new JWindowEx(w);
        this.m_swingWindow.getRootPane().putClientProperty("SwingBusyIndicator.busySupported", true);
        this.m_swingWindow.addWindowListener(new P_SwingWindowListener());
        if (!SwingUtility.isSynth()) {
            this.m_swingWindow.getRootPane().setBorder(UIManager.getBorder("SwingScoutPopup.border"));
        }
        JComponent contentPane = (JComponent)this.m_swingWindow.getContentPane();
        contentPane.setLayout(new P_PopupContentPaneLayout());
        contentPane.setCursor(Cursor.getDefaultCursor());
        this.m_swingWindow.getRootPane().setName("Synth.Popup");
        this.m_swingWindow.pack();
    }

    public int getFixedWidth() {
        return this.m_fixedWidth;
    }

    public void setFixedWidth(int fixedWidth) {
        this.m_fixedWidth = fixedWidth;
    }

    public boolean isPopupOnField() {
        return this.m_popupOnField;
    }

    public void setPopupOnField(boolean popupOnField) {
        this.m_popupOnField = popupOnField;
    }

    public boolean isPopupBelow() {
        return this.m_positionBelowReferenceField;
    }

    public void autoAdjustBounds() {
        try {
            if (this.m_ownerComponent.isShowing()) {
                if (this.m_ownerBounds.width == 0 && this.m_ownerBounds.height == 0) {
                    this.m_ownerBounds.setSize(this.m_ownerComponent.getWidth(), this.m_ownerComponent.getHeight());
                }
                this.m_swingWindow.validate();
                this.m_swingWindow.getRootPane().revalidate();
                Dimension dimPref = this.m_swingWindow.getPreferredSize();
                Dimension dimMin = this.m_swingWindow.getMinimumSize();
                if (this.getFixedWidth() > 0) {
                    dimPref.width = this.getFixedWidth();
                    dimMin.width = this.getFixedWidth();
                } else if (!this.m_swingWindow.isPreferredSizeSet()) {
                    dimPref.width = Math.max(this.m_env.getFormColumnWidth() / 2, dimPref.width);
                    dimMin.width = Math.max(this.m_env.getFormColumnWidth() / 2, dimMin.width);
                }
                dimPref.width = Math.max(dimPref.width, dimMin.width);
                dimPref.height = Math.max(dimPref.height, dimMin.height);
                Point p = this.m_ownerBounds.getLocation();
                Point above = new Point(p.x, p.y);
                above.y = this.m_popupOnField ? (above.y += this.m_ownerBounds.height) : (above.y -= 2);
                Rectangle aboveView = SwingUtility.intersectRectangleWithScreen(new Rectangle(above.x, above.y - dimPref.height, dimPref.width, dimPref.height), false, false);
                if (aboveView.width < dimMin.width) {
                    aboveView.x = aboveView.x + aboveView.width - dimMin.width;
                    aboveView.width = dimMin.width;
                }
                Point below = new Point(p.x, p.y);
                if (!this.m_popupOnField) {
                    below.y += this.m_ownerBounds.height + 2;
                }
                Rectangle belowView = SwingUtility.intersectRectangleWithScreen(new Rectangle(below.x, below.y, dimPref.width, dimPref.height), false, false);
                if (belowView.width < dimMin.width) {
                    belowView.x = belowView.x + belowView.width - dimMin.width;
                    belowView.width = dimMin.width;
                }
                Rectangle currentView = this.m_positionBelowReferenceField ? belowView : aboveView;
                Rectangle alternateView = this.m_positionBelowReferenceField ? aboveView : belowView;
                Rectangle ownerScreen = SwingUtility.getFullScreenBoundsFor(this.m_ownerBounds, false);
                if (currentView.height >= alternateView.height) {
                    this.m_swingWindow.setBounds(SwingUtility.validateRectangleOnScreen(currentView, ownerScreen, true, true));
                } else {
                    this.m_swingWindow.setBounds(SwingUtility.validateRectangleOnScreen(alternateView, ownerScreen, true, true));
                    this.m_positionBelowReferenceField = !this.m_positionBelowReferenceField;
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected", t);
        }
    }

    public Window getSwingWindow() {
        return this.m_swingWindow;
    }

    public boolean isResizable() {
        return this.m_resizable;
    }

    public void setResizable(boolean resizable) {
        if (this.m_resizable == resizable) {
            return;
        }
        this.m_resizable = resizable;
        if (resizable) {
            this.m_swingWindow.addMouseListener(this.m_resizeListener);
            this.m_swingWindow.addMouseMotionListener(this.m_resizeListener);
        } else {
            this.m_swingWindow.removeMouseListener(this.m_resizeListener);
            this.m_swingWindow.removeMouseMotionListener(this.m_resizeListener);
        }
    }

    public Component getSwingOwnerComponent() {
        return this.m_ownerComponent;
    }

    @Override
    public JComponent getSwingContentPane() {
        return (JComponent)this.m_swingWindow.getContentPane();
    }

    @Override
    public void addSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.add(SwingScoutViewListener.class, (EventListener)listener);
    }

    @Override
    public void removeSwingScoutViewListener(SwingScoutViewListener listener) {
        this.m_listenerList.remove(SwingScoutViewListener.class, (EventListener)listener);
    }

    protected void fireSwingScoutViewEvent(SwingScoutViewEvent e) {
        switch (e.getType()) {
            case 10: {
                this.m_closeFired = false;
                break;
            }
            case 40: {
                if (this.m_closeFired) {
                    return;
                }
                this.m_closeFired = true;
            }
        }
        EventListener[] listeners = this.m_listenerList.getListeners(SwingScoutViewListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    ((SwingScoutViewListener)listeners[i]).viewChanged(e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected void handleSwingWindowOpened() {
        this.registerOwnerComponentListener();
        this.fireSwingScoutViewEvent(new SwingScoutViewEvent(this, 10));
    }

    protected void handleSwingWindowClosed() {
        Component focusOwner;
        this.unregisterOwnerComponentListener();
        if (this.getSwingWindow().isFocused() && (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null) {
            ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner);
        }
        this.fireSwingScoutViewEvent(new SwingScoutViewEvent(this, 40));
    }

    protected void registerOwnerComponentListener() {
        if (this.m_ownerComponentListener == null) {
            this.m_ownerComponentListener = new P_OwnerComponentListener();
            this.getSwingWindow().getOwner().addComponentListener(this.m_ownerComponentListener);
        }
    }

    protected void unregisterOwnerComponentListener() {
        if (this.m_ownerComponentListener != null) {
            this.getSwingWindow().getOwner().removeComponentListener(this.m_ownerComponentListener);
            this.m_ownerComponentListener = null;
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_swingWindow != null && this.m_swingWindow.isVisible();
    }

    @Override
    public boolean isActive() {
        return this.m_swingWindow != null && this.m_swingWindow.isActive();
    }

    @Override
    public void openView() {
        this.m_opened = true;
        this.autoAdjustBounds();
        if (this.m_opened) {
            this.m_swingWindow.setVisible(true);
        }
    }

    @Override
    public void closeView() {
        if (this.m_opened) {
            this.m_opened = false;
            new DependentCloseListener(this.m_swingWindow).close();
        }
    }

    @Override
    public void setTitle(String s) {
    }

    @Override
    public void setCloseEnabled(boolean b) {
    }

    @Override
    public void setMaximizeEnabled(boolean b) {
    }

    @Override
    public void setMinimizeEnabled(boolean b) {
    }

    @Override
    public void setMinimized(boolean on) {
    }

    @Override
    public void setMaximized(boolean on) {
        this.m_maximized = on;
        if (on) {
            if (this.m_boundsBeforeMaximize == null) {
                this.m_boundsBeforeMaximize = this.m_swingWindow.getBounds();
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Insets in = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            Rectangle r = new Rectangle();
            if (in != null) {
                r.x = in.left;
                r.y = in.top;
                r.width = d.width - in.left - in.right;
                r.height = d.height - in.top - in.bottom;
            } else {
                r.x = 0;
                r.y = 0;
                r.width = d.width;
                r.height = d.height;
            }
            this.m_swingWindow.setBounds(r);
        } else if (this.m_boundsBeforeMaximize != null) {
            this.m_swingWindow.setBounds(this.m_boundsBeforeMaximize);
            this.m_boundsBeforeMaximize = null;
        }
    }

    @Override
    public void setName(String name) {
        this.m_swingWindow.setName(name);
        this.m_swingWindow.getRootPane().setName(name);
    }

    private class P_OwnerComponentListener
    extends ComponentAdapter {
        private P_OwnerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SwingScoutPopup.this.handleSwingWindowClosed();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            SwingScoutPopup.this.handleSwingWindowClosed();
        }
    }

    private class P_PopupContentPaneLayout
    extends AbstractLayoutManager2 {
        private P_PopupContentPaneLayout() {
        }

        @Override
        protected Dimension getLayoutSize(Container parent, int sizeflag) {
            Dimension ps;
            Component c;
            Insets insets = parent.getInsets();
            Dimension d = new Dimension();
            d.width = 0;
            Component[] componentArray = parent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                ps = SwingLayoutUtility.getSize(c, sizeflag);
                d.width += ps.width;
                ++n2;
            }
            d.width += insets.left + insets.right;
            d.height = 0;
            componentArray = parent.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                c = componentArray[n2];
                ps = SwingLayoutUtility.getSize(c, sizeflag);
                d.height = Math.max(d.height, ps.height);
                ++n2;
            }
            d.height += insets.top + insets.bottom;
            return d;
        }

        @Override
        protected void validateLayout(Container parent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            this.verifyLayout(parent);
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (!SwingUtility.IS_JAVA_7_OR_GREATER && SwingUtility.DO_RESET_COMPONENT_BOUNDS) {
                    SwingUtility.setZeroBounds(parent.getComponents());
                }
                Insets insets = parent.getInsets();
                Rectangle view = new Rectangle(insets.left, insets.top, parent.getWidth() - insets.left - insets.right, parent.getHeight() - insets.top - insets.bottom);
                if (parent.getComponentCount() > 0) {
                    parent.getComponent(0).setBounds(view.x, view.y, view.width, view.height);
                }
            }
        }
    }

    private class P_ResizeListener
    extends MouseAdapter
    implements MouseMotionListener {
        private static final int NO_RESIZE = 0;
        private static final int RESIZE_EAST = 2;
        private static final int RESIZE_SOUTH = 4;
        private static final int RESIZE_NORTH = 8;
        private int m_direction = 0;

        private P_ResizeListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_direction = 0;
            SwingScoutPopup.this.m_swingWindow.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.m_direction = this.getDirection(mouseEvent);
            SwingScoutPopup.this.m_swingWindow.setCursor(this.getCursor(this.m_direction));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int delta;
            Rectangle originalBounds = SwingScoutPopup.this.m_swingWindow.getBounds();
            Rectangle newBounds = new Rectangle(originalBounds);
            Point mousePosition = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(mousePosition, SwingScoutPopup.this.m_swingWindow);
            if ((this.m_direction & 2) > 0) {
                int xEast = originalBounds.x + originalBounds.width;
                delta = mousePosition.x - xEast;
                newBounds.width = Math.max(((SwingScoutPopup)SwingScoutPopup.this).m_swingWindow.getMinimumSize().width, originalBounds.width + delta);
            }
            if ((this.m_direction & 4) > 0) {
                int yBottom = originalBounds.y + originalBounds.height;
                delta = mousePosition.y - yBottom;
                newBounds.height = Math.max(((SwingScoutPopup)SwingScoutPopup.this).m_swingWindow.getMinimumSize().height, originalBounds.height + delta);
            }
            if ((this.m_direction & 8) > 0) {
                int yTop = originalBounds.y;
                delta = yTop - mousePosition.y;
                newBounds.height = Math.max(((SwingScoutPopup)SwingScoutPopup.this).m_swingWindow.getMinimumSize().height, originalBounds.height + delta);
                newBounds.y = yTop + originalBounds.height - newBounds.height;
            }
            SwingScoutPopup.this.m_swingWindow.setBounds(newBounds);
            SwingScoutPopup.this.m_swingWindow.validate();
            SwingScoutPopup.this.m_swingWindow.repaint();
        }

        private int getDirection(MouseEvent event) {
            Dimension dimension = SwingScoutPopup.this.m_swingWindow.getSize();
            Insets insets = SwingScoutPopup.this.m_swingWindow.getRootPane().getInsets();
            int eastBorder = dimension.width - insets.right;
            int bottomBorder = dimension.height - insets.bottom;
            int topBorder = insets.bottom;
            Point mousePosition = event.getPoint();
            int direction = 0;
            if (mousePosition.x >= eastBorder) {
                direction |= 2;
            }
            if (SwingScoutPopup.this.isPopupBelow()) {
                if (mousePosition.y >= bottomBorder) {
                    direction |= 4;
                }
            } else if (mousePosition.y <= topBorder) {
                direction |= 8;
            }
            return direction;
        }

        private Cursor getCursor(int direction) {
            int cursorType = 0;
            switch (direction) {
                case 2: {
                    cursorType = 11;
                    break;
                }
                case 4: {
                    cursorType = 9;
                    break;
                }
                case 8: {
                    cursorType = 8;
                    break;
                }
                case 6: {
                    cursorType = 5;
                    break;
                }
                case 10: {
                    cursorType = 7;
                    break;
                }
                default: {
                    cursorType = 0;
                }
            }
            return Cursor.getPredefinedCursor(cursorType);
        }
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingScoutPopup.this.handleSwingWindowOpened();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SwingScoutPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutPopup.this, 20));
        }

        @Override
        public void windowClosing(WindowEvent e) {
            boolean ok;
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
                return;
            }
            SwingScoutPopup.this.fireSwingScoutViewEvent(new SwingScoutViewEvent(SwingScoutPopup.this, 30));
        }

        @Override
        public void windowClosed(WindowEvent e) {
            SwingScoutPopup.this.handleSwingWindowClosed();
        }
    }
}

