/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.rap.ui.SdkRapIcons;
import org.eclipse.scout.sdk.rap.ui.internal.action.RapTargetNewAction;
import org.eclipse.scout.sdk.rap.var.IRapTargetVariableListener;
import org.eclipse.scout.sdk.rap.var.RapTargetVariable;
import org.eclipse.scout.sdk.rap.var.RapTargetVariableListenerAdapter;
import org.eclipse.scout.sdk.ui.extensions.executor.ExecutorExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.ImageRegistry;
import org.eclipse.scout.sdk.util.log.SdkLogManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ScoutSdkRapUI
extends AbstractUIPlugin
implements SdkRapIcons {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.rap.ui";
    private static final String RAP_TARGET_VARIABLE_EMPTY_MSG = "scoutRapTargetVarEmptyMsg";
    private static final String IMAGE_PATH = "resources/icons/";
    private static ScoutSdkRapUI plugin;
    private static SdkLogManager logManager;
    private static P_ScoutTargetVariableListener listener;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        logManager = new SdkLogManager((Plugin)this);
        listener = new P_ScoutTargetVariableListener(this.getPreferenceStore());
        RapTargetVariable.get().addListener((IRapTargetVariableListener)listener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        RapTargetVariable.get().removeListener((IRapTargetVariableListener)listener);
        listener = null;
        logManager = null;
        plugin = null;
    }

    public static ScoutSdkRapUI getDefault() {
        return plugin;
    }

    public static void logInfo(Throwable t) {
        logManager.logInfo(t);
    }

    public static void logInfo(String message) {
        logManager.logInfo(message);
    }

    public static void logInfo(String message, Throwable t) {
        logManager.logInfo(message, t);
    }

    public static void logWarning(String message) {
        logManager.logWarning(message);
    }

    public static void logWarning(Throwable t) {
        logManager.logWarning(t);
    }

    public static void logWarning(String message, Throwable t) {
        logManager.logWarning(message, t);
    }

    public static void logError(Throwable t) {
        logManager.logError(t);
    }

    public static void logError(String message) {
        logManager.logError(message);
    }

    public static void logError(String message, Throwable t) {
        logManager.logError(message, t);
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public ImageRegistry getImageRegistry() {
        return (ImageRegistry)super.getImageRegistry();
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        return ScoutSdkRapUI.getDefault().getImageImpl(imageDescriptor);
    }

    private Image getImageImpl(CompositeImageDescriptor imageDescriptor) {
        return this.getImageRegistry().get((ImageDescriptor)imageDescriptor);
    }

    public static Image getImage(String name) {
        return ScoutSdkRapUI.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        Image image = this.getImageRegistry().get(name);
        if (image == null) {
            this.loadImage(name);
            image = this.getImageRegistry().get(name);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return ScoutSdkRapUI.getDefault().getImageDescriptorImpl(name);
    }

    private ImageDescriptor getImageDescriptorImpl(String name) {
        ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(name);
        if (imageDesc == null) {
            this.loadImage(name);
            imageDesc = this.getImageRegistry().getDescriptor(name);
        }
        return imageDesc;
    }

    private void loadImage(String name) {
        ImageDescriptor desc = null;
        if (name.startsWith(IMAGE_PATH)) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)name);
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".gif"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".png"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".jpg"));
        }
        if (desc == null) {
            ScoutSdkRapUI.logWarning("could not find image for plugin: 'org.eclipse.scout.sdk.rap.ui' under: 'resources/icons/" + name + "'.");
        } else {
            this.getImageRegistry().put(name, desc);
        }
    }

    private static Display getDisplay() {
        Display d = Display.getDefault();
        if (d == null) {
            d = PlatformUI.getWorkbench().getDisplay();
        }
        return d;
    }

    private static final class P_ScoutTargetVariableListener
    extends RapTargetVariableListenerAdapter {
        private final IPreferenceStore m_store;

        private P_ScoutTargetVariableListener(IPreferenceStore store) {
            this.m_store = store;
        }

        public synchronized void emptyVariableInUse(final IFile targetFile) {
            if (this.isShowMessage()) {
                final Display display = ScoutSdkRapUI.getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle msgbox = MessageDialogWithToggle.openYesNoQuestion((Shell)display.getActiveShell(), (String)Texts.get((String)"NoRAPTargetLocationDefined"), (String)Texts.get((String)"EmptyRapTargetVarFoundMsg", (String[])new String[]{"scout_rap_target", targetFile.getLocation().toOSString()}), (String)Texts.get((String)"DoNotShowAgain"), (boolean)false, (IPreferenceStore)P_ScoutTargetVariableListener.this.m_store, (String)ScoutSdkRapUI.RAP_TARGET_VARIABLE_EMPTY_MSG);
                        if (msgbox.getReturnCode() == 2) {
                            ExecutorExtensionPoint.getExecutorFor((String)RapTargetNewAction.class.getName()).run(display.getActiveShell(), (IStructuredSelection)new StructuredSelection((Object)targetFile), new ExecutionEvent());
                        }
                    }
                });
            }
        }

        private boolean isShowMessage() {
            String doNotShowAgainString = this.m_store.getString(ScoutSdkRapUI.RAP_TARGET_VARIABLE_EMPTY_MSG);
            return !"never".equals(doNotShowAgainString);
        }
    }
}

