/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.wizard.var;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.rap.operations.project.AppendRapTargetOperation;
import org.eclipse.scout.sdk.rap.operations.project.ScoutRapTargetCreationOperation;
import org.eclipse.scout.sdk.rap.ui.internal.wizard.project.RapTargetPlatformWizardPage;
import org.eclipse.scout.sdk.rap.var.RapTargetVariable;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.ui.IWorkbench;

public class RapTargetNewWizard
extends AbstractWorkspaceWizard {
    private RapTargetPlatformWizardPage m_page1;
    private AppendRapTargetOperation.TargetStrategy m_strategy;
    private String m_localFolder;
    private String m_extractFolder;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Texts.get((String)"SpecifyTheRAPTargetLocation"));
        this.m_page1 = new RapTargetPlatformWizardPage(new AppendRapTargetOperation.TargetStrategy[]{AppendRapTargetOperation.TargetStrategy.STRATEGY_LOCAL_EXISTING, AppendRapTargetOperation.TargetStrategy.STRATEGY_LOCAL_EXTRACT});
        this.m_page1.setTitle(Texts.get((String)"SpecifyTheRAPTargetLocation"));
        this.addPage((IWizardPage)this.m_page1);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_strategy = this.m_page1.getTargetStrategy();
        this.m_localFolder = this.m_page1.getLocalTargetFolder();
        this.m_extractFolder = this.m_page1.getExtractTargetFolder();
        return super.beforeFinish();
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (AppendRapTargetOperation.TargetStrategy.STRATEGY_LOCAL_EXISTING.equals((Object)this.m_strategy)) {
            File f = new File(this.m_localFolder);
            RapTargetVariable.get().setValue(f.getAbsolutePath());
        } else {
            File f = new File(this.m_extractFolder);
            ScoutRapTargetCreationOperation scoutRapTargetExtractOp = new ScoutRapTargetCreationOperation();
            scoutRapTargetExtractOp.setDestinationDirectory(f);
            scoutRapTargetExtractOp.validate();
            scoutRapTargetExtractOp.run(monitor, workingCopyManager);
            RapTargetVariable.get().setValue(f.getAbsolutePath());
        }
        return true;
    }
}

