/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.viewer.ScoutBundleLableProvider;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class ScoutBundleSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = ScoutBundleSelectionDialog.class.getName();
    private Set<IScoutBundle> m_bundles;

    public ScoutBundleSelectionDialog(Shell shell, boolean multiSelect) {
        this(shell, ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getAllBundlesFilter()), multiSelect);
    }

    public ScoutBundleSelectionDialog(Shell shell, Set<IScoutBundle> bundles, boolean multiSelect) {
        super(shell, multiSelect);
        this.setListLabelProvider(new ScoutBundleLableProvider());
        this.setDetailsLabelProvider(new ScoutBundleLableProvider());
        this.setInitialPattern("**");
        this.setHelpAvailable(false);
        this.m_bundles = bundles;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public int open() {
        return super.open();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new P_BundleSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (IScoutBundle project : this.m_bundles) {
            contentProvider.add((Object)project, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ScoutSdkUi.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ScoutSdkUi.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IScoutBundle) {
            return ((IScoutBundle)item).getSymbolicName();
        }
        return null;
    }

    protected Comparator getItemsComparator() {
        return new P_BundleSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.scout.sdk.ui", 0, "", null);
    }

    private class P_BundleSearchComparator
    implements Comparator {
        private P_BundleSearchComparator() {
        }

        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IJavaProject) {
                return 100;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IScoutBundle && o2 instanceof IScoutBundle) {
                IScoutBundle ipmb1 = (IScoutBundle)o1;
                IScoutBundle ipmb2 = (IScoutBundle)o2;
                return ipmb1.getSymbolicName().compareTo(ipmb2.getSymbolicName());
            }
            return 0;
        }
    }

    private class P_BundleSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private P_BundleSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)ScoutBundleSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IScoutBundle) {
                IScoutBundle project = (IScoutBundle)item;
                id = project.getSymbolicName();
            }
            return this.matches(id);
        }

        protected boolean matches(String text) {
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf("*") != 0 && pattern.indexOf("?") != 0 && pattern.indexOf(".") != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
            return this.patternMatcher.matches(text);
        }
    }
}

