/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.wizard.IWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.ScoutWizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardExecutor
extends AbstractExecutor {
    private Map<Double, IOperation> m_performFinishOperations;

    protected AbstractWizardExecutor() {
    }

    public IOperation addAdditionalPerformFinishOperation(IOperation op, double orderNr) {
        if (this.m_performFinishOperations == null) {
            this.m_performFinishOperations = new TreeMap<Double, IOperation>();
        }
        return this.m_performFinishOperations.put(orderNr, op);
    }

    @Override
    public final Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        INewWizard newWizardInstance = this.getNewWizardInstance();
        if (newWizardInstance != null) {
            newWizardInstance.init(PlatformUI.getWorkbench(), selection);
            if (this.m_performFinishOperations != null && newWizardInstance instanceof IWorkspaceWizard) {
                IWorkspaceWizard workspaceWiz = (IWorkspaceWizard)newWizardInstance;
                for (Map.Entry<Double, IOperation> entry : this.m_performFinishOperations.entrySet()) {
                    workspaceWiz.addAdditionalPerformFinishOperation(entry.getValue(), entry.getKey());
                }
            }
            ScoutWizardDialog wizardDialog = new ScoutWizardDialog(shell, (IWizard)newWizardInstance);
            wizardDialog.open();
        }
        return null;
    }

    public abstract INewWizard getNewWizardInstance();
}

