/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.sql.binding.FormDataSqlBindingValidator;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.BundleNodeGroupTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerNodePage;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.swt.widgets.Shell;

public class FormDataSqlBindingValidateExecutor
extends AbstractExecutor {
    private ITypeResolver m_resolver = null;

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        new Job("Validate FormData SQL Bindings"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new FormDataSqlBindingValidator(FormDataSqlBindingValidateExecutor.this.m_resolver.getTypes()).run(monitor);
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not execute formdata sql binding validation.", e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return null;
    }

    @Override
    public boolean canRun(IStructuredSelection selection) {
        final Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof BundleNodeGroupTablePage) {
            this.m_resolver = new ITypeResolver(){

                public Set<IType> getTypes() {
                    IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
                    ICachedTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
                    IScoutBundle scoutBundle = ((BundleNodeGroupTablePage)selectedElement).getScoutBundle();
                    Set serverBundles = scoutBundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), true);
                    return serviceHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getClassesInScoutBundles((Collection)serverBundles));
                }
            };
        } else if (selectedElement instanceof ServerNodePage) {
            this.m_resolver = new ITypeResolver(){

                public Set<IType> getTypes() {
                    IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
                    ICachedTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
                    IScoutBundle bundle = ((ServerNodePage)selectedElement).getScoutBundle();
                    return serviceHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)bundle));
                }
            };
        } else if (selectedElement instanceof AbstractServiceNodePage) {
            this.m_resolver = new ITypeResolver(){

                public Set<IType> getTypes() {
                    return CollectionUtility.hashSet((Object)((AbstractServiceNodePage)selectedElement).getType());
                }
            };
        } else if (selectedElement instanceof ITypeResolver) {
            this.m_resolver = (ITypeResolver)selectedElement;
        }
        return this.m_resolver != null && this.isEditable(UiUtility.getScoutBundleFromSelection(selection));
    }
}

