/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.form.field.BoxDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.swt.widgets.Shell;

public class FormFieldDeleteExecutor
extends AbstractExecutor {
    private Set<IType> m_fieldTypes;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_fieldTypes = UiUtility.getTypesFromSelection(selection, null);
        return this.isEditable(this.m_fieldTypes);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        MemberSelectionDialog confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"DeleteFormField"), Texts.get((String)"SelectFieldsToRemove"));
        confirmDialog.setMembers(this.m_fieldTypes);
        confirmDialog.setSelectedMembers(this.m_fieldTypes);
        if (confirmDialog.open() == 0) {
            Set<? extends IMember> selectedMembers = confirmDialog.getSelectedMembers();
            ArrayList<BoxDeleteOperation> deleteOps = new ArrayList<BoxDeleteOperation>(selectedMembers.size());
            for (IMember iMember : selectedMembers) {
                deleteOps.add(new BoxDeleteOperation((IType)iMember));
            }
            new OperationJob(deleteOps).schedule();
        }
        return null;
    }
}

