/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.executor.AbstractRenameExecutor;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class FormFieldRenameExecutor
extends AbstractRenameExecutor {
    private IType m_formField;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        boolean superRun = super.canRun(selection);
        if (!superRun) {
            return false;
        }
        this.m_formField = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_formField);
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_formField, newName);
        IMethod getter = ScoutTypeUtility.getFormFieldGetterMethod((IType)this.m_formField);
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + NamingUtility.ensureStartWithUpperCase((String)newName));
        }
    }

    @Override
    protected IStatus validate(String newName) {
        return ScoutUtility.validateFormFieldName((String)newName, (String)"Field", (IType)this.m_formField);
    }
}

