/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServiceOperationNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class MemberListDeleteExecutor
extends AbstractExecutor {
    private Set<IMember> m_membersToDelete;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_membersToDelete = this.collectMembersToDelete(selection);
        return this.isEditable(this.m_membersToDelete);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        final MemberSelectionDialog confirmDialog = new MemberSelectionDialog(shell, "Delete");
        confirmDialog.addMemberSelectionListener(new IMemberSelectionChangedListener(){

            @Override
            public void handleSelectionChanged(Set<? extends IMember> s) {
                confirmDialog.setMessage("");
                confirmDialog.getOkButton().setEnabled(CollectionUtility.hasElements(s));
            }
        });
        confirmDialog.setMembers(this.m_membersToDelete);
        confirmDialog.setSelectedMembers(this.m_membersToDelete);
        if (confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation();
            op.setMembers(confirmDialog.getSelectedMembers());
            new OperationJob(new IOperation[]{op}).schedule();
        }
        return null;
    }

    protected Set<IMember> collectMembersToDelete(IStructuredSelection selection) {
        LinkedHashSet<IMember> membersToDelete = new LinkedHashSet<IMember>();
        for (Object selObject : selection) {
            if (selObject instanceof ServiceOperationNodePage) {
                ServiceOperationNodePage sonp = (ServiceOperationNodePage)selObject;
                if (TypeUtility.exists((IJavaElement)sonp.getImplementationOpMethod())) {
                    membersToDelete.add((IMember)sonp.getImplementationOpMethod());
                }
                if (!TypeUtility.exists((IJavaElement)sonp.getInterfaceOpMethod())) continue;
                membersToDelete.add((IMember)sonp.getInterfaceOpMethod());
                continue;
            }
            if (selObject instanceof SharedContextPropertyNodePage) {
                SharedContextPropertyNodePage scpnp = (SharedContextPropertyNodePage)selObject;
                if (scpnp.getServerDesc() != null) {
                    membersToDelete.addAll(scpnp.getServerDesc().getAllMembers());
                }
                if (scpnp.getClientDesc() == null) continue;
                membersToDelete.addAll(scpnp.getClientDesc().getAllMembers());
                continue;
            }
            if (!(selObject instanceof BeanPropertyNodePage)) continue;
            BeanPropertyNodePage bpnp = (BeanPropertyNodePage)selObject;
            membersToDelete.addAll(bpnp.getPropertyDescriptor().getAllMembers());
        }
        return membersToDelete;
    }
}

