/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.field.table.TableColumnDeleteOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnDeleteExecutor
extends AbstractExecutor {
    private Set<IType> m_selectedColumns;

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        MessageBox box = new MessageBox(shell, 292);
        if (this.m_selectedColumns.size() == 1) {
            box.setMessage(Texts.get((String)"Action_deleteNameX", (String[])new String[]{((IType)CollectionUtility.firstElement(this.m_selectedColumns)).getElementName()}));
        } else {
            box.setMessage(Texts.get((String)"ColumnDeleteConfirmationMessage"));
        }
        if (box.open() == 32) {
            TableColumnDeleteOperation delOp = new TableColumnDeleteOperation(this.m_selectedColumns);
            new OperationJob(new IOperation[]{delOp}).schedule();
        }
        return null;
    }

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_selectedColumns = UiUtility.getTypesFromSelection(selection, null);
        if (this.m_selectedColumns.size() < 1) {
            return false;
        }
        for (IType col : this.m_selectedColumns) {
            if (this.isEditable((IJavaElement)col)) continue;
            return false;
        }
        return true;
    }
}

