/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.executor.AbstractRenameExecutor;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class TableColumnRenameExecutor
extends AbstractRenameExecutor {
    private IType m_tableColumn;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        boolean superRun = super.canRun(selection);
        if (!superRun) {
            return false;
        }
        this.m_tableColumn = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_tableColumn);
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_tableColumn, newName);
        IMethod getter = ScoutTypeUtility.getColumnGetterMethod((IType)this.m_tableColumn);
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + NamingUtility.ensureStartWithUpperCase((String)newName));
        }
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = ScoutUtility.validateJavaName((String)newName, (String)this.getReadOnlySuffix());
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.m_tableColumn.getDeclaringType().getType(newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return inheritedStatus;
    }
}

