/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectsTablePage;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.dto.formdata.MultipleFormDataUpdateOperation;
import org.eclipse.swt.widgets.Shell;

public class TypeResolverFormDataExecutor
extends AbstractExecutor {
    private ITypeResolver m_resolver;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        IScoutBundle scoutBundle = UiUtility.getScoutBundleFromSelection(selection);
        if (selectedElement instanceof ProjectsTablePage) {
            this.m_resolver = new ITypeResolver(){

                public Set<IType> getTypes() {
                    IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
                    ICachedTypeHierarchy formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iForm);
                    return formHierarchy.getAllSubtypes(iForm);
                }
            };
        } else if (selectedElement instanceof ITypeResolver) {
            this.m_resolver = (ITypeResolver)selectedElement;
        }
        return this.m_resolver != null && (scoutBundle == null || !scoutBundle.isBinary());
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        new OperationJob(new IOperation[]{new MultipleFormDataUpdateOperation(this.m_resolver)}).schedule();
        return null;
    }
}

