/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class WizardStepDeleteExecutor
extends AbstractExecutor {
    private Set<IType> m_selectedSteps;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_selectedSteps = UiUtility.getTypesFromSelection(selection, null);
        return this.isEditable(this.m_selectedSteps);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        MessageBox box = new MessageBox(shell, 292);
        if (this.m_selectedSteps.size() == 1) {
            box.setMessage(Texts.get((String)"StepDeleteConfirmationMessage"));
        } else {
            box.setMessage(Texts.get((String)"StepDeleteConfirmationMessagePlural"));
        }
        if (box.open() == 32) {
            JavaElementDeleteOperation delOp = new JavaElementDeleteOperation();
            for (IType stepToDelete : this.m_selectedSteps) {
                delOp.addMember((IJavaElement)stepToDelete);
                IMethod getter = ScoutTypeUtility.getWizardStepGetterMethod((IType)stepToDelete);
                if (!TypeUtility.exists((IJavaElement)getter)) continue;
                delOp.addMember((IJavaElement)getter);
            }
            new OperationJob(new IOperation[]{delOp}).schedule();
        }
        return null;
    }
}

