/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class DefaultSuperClassModel
implements Comparable<DefaultSuperClassModel> {
    private static final Pattern INTERFACE_REGEX = Pattern.compile(".*(\\.I|.Abstract)([^\\.]*)$");
    private static final Pattern SPLIT_REGEX = Pattern.compile("([A-Z])");
    final String interfaceFqn;
    final String defaultVal;
    final String label;
    final IScoutBundle scoutProject;
    private String[] m_proposals;
    private String[] m_proposalDisplayTexts;
    private int m_initialSelectedIndex;
    private int m_defaultIndex;

    DefaultSuperClassModel(String ifFqn, String def, IScoutBundle p) {
        this.interfaceFqn = ifFqn;
        this.defaultVal = def;
        this.scoutProject = p;
        this.label = DefaultSuperClassModel.getLabelTextFromInterfaceFqn(this.interfaceFqn);
    }

    public void load() {
        this.m_proposals = DefaultSuperClassModel.getTypeProposals(this.scoutProject, this.interfaceFqn, this.defaultVal);
        this.m_proposalDisplayTexts = DefaultSuperClassModel.getFqnDisplayTexts(this.m_proposals);
        this.m_initialSelectedIndex = DefaultSuperClassModel.indexOf(this.m_proposals, RuntimeClasses.getSuperTypeName((String)this.interfaceFqn, (IJavaProject)this.scoutProject.getJavaProject()));
        this.m_defaultIndex = DefaultSuperClassModel.indexOf(this.m_proposals, this.defaultVal);
    }

    public int getInitialSelectetdIndex() {
        return this.m_initialSelectedIndex;
    }

    public int getDefaultIndex() {
        return this.m_defaultIndex;
    }

    public String[] getProposalDisplayTexts() {
        return Arrays.copyOf(this.m_proposalDisplayTexts, this.m_proposalDisplayTexts.length);
    }

    public String[] getProposals() {
        return Arrays.copyOf(this.m_proposals, this.m_proposals.length);
    }

    public static int indexOf(String[] items, String search) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(search)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String[] getTypeProposals(IScoutBundle p, String interfaceFqn, String defaultVal) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(defaultVal);
        IType base = TypeUtility.getType((String)interfaceFqn);
        ICachedTypeHierarchy typeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)base);
        Set allSubtypes = typeHierarchy.getAllSubtypes(base, TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)p.getJavaProject()), TypeFilters.getFlagsFilter((int)1024)}), null);
        for (IType t : allSubtypes) {
            if (!TypeUtility.exists((IJavaElement)t)) continue;
            ret.add(t.getFullyQualifiedName());
        }
        Object[] arr = ret.toArray(new String[ret.size()]);
        Arrays.sort(arr);
        return arr;
    }

    private static String[] getFqnDisplayTexts(String[] items) {
        int MAX_LEN = 38;
        String DOTS = "...";
        String[] ret = new String[items.length];
        int i = 0;
        while (i < items.length) {
            String cur = items[i];
            if (cur.length() > 38) {
                int allowedTextLen;
                int lastDot = cur.lastIndexOf(46) + 1;
                int lastSegLength = cur.length() - lastDot;
                if (lastSegLength >= (allowedTextLen = 38 - "...".length()) - 1) {
                    ret[i] = "..." + cur.substring(cur.length() - allowedTextLen);
                } else {
                    String simpleName = cur.substring(cur.length() - lastSegLength);
                    int firstSegLen = allowedTextLen - simpleName.length();
                    String inject = "...";
                    if (cur.charAt(firstSegLen - 1) == '.') {
                        inject = "...".substring(1);
                    }
                    ret[i] = String.valueOf(cur.substring(0, firstSegLen)) + inject + simpleName;
                }
            } else {
                ret[i] = items[i];
            }
            ++i;
        }
        return ret;
    }

    private static String getLabelTextFromInterfaceFqn(String fqn) {
        Matcher m = INTERFACE_REGEX.matcher(fqn);
        if (m.find()) {
            return SPLIT_REGEX.matcher(m.group(2)).replaceAll(" $1").trim();
        }
        return fqn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultSuperClassModel)) {
            return false;
        }
        return this.label.equals(((DefaultSuperClassModel)obj).label);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    @Override
    public int compareTo(DefaultSuperClassModel o) {
        return this.label.compareTo(o.label);
    }
}

