/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.extensions.preferences.IScoutProjectScrolledContent;
import org.eclipse.scout.sdk.ui.extensions.preferences.TargetPackageModel;
import org.eclipse.scout.sdk.ui.fields.SimpleScrolledComposite;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.osgi.service.prefs.BackingStoreException;

public class TargetPackagePreferenceScrolledContent
implements IScoutProjectScrolledContent<TargetPackageModel> {
    private final List<EntityTextField> m_allEntityTextFields = new ArrayList<EntityTextField>();
    private List<TargetPackageModel> m_entries;
    private SimpleScrolledComposite m_scrollArea;

    @Override
    public void loadModel(List<TargetPackageModel> entries, IScoutProjectScrolledContent.IModelLoadProgressObserver<TargetPackageModel> observer, IProgressMonitor monitor) {
        this.m_entries = new ArrayList<TargetPackageModel>(entries);
        for (TargetPackageModel model : this.m_entries) {
            model.load();
            if (observer == null) continue;
            observer.loaded(model);
        }
    }

    @Override
    public void createContent(Composite parent) {
        this.m_scrollArea = new SimpleScrolledComposite(parent);
        Composite c = this.m_scrollArea.getBody();
        GridLayout gl = new GridLayout(1, false);
        gl.horizontalSpacing = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        for (TargetPackageModel entry : this.m_entries) {
            EntityTextField txt = new EntityTextField(c, entry.m_label, 40, entry.m_context);
            txt.setText(entry.m_curVal);
            txt.setEnabled(DefaultTargetPackage.isPackageConfigurationEnabled());
            txt.setLayoutData(new GridData(768));
            this.m_allEntityTextFields.add(txt);
        }
    }

    @Override
    public void save() {
        final HashSet modifiedProjects = new HashSet(1);
        this.visitTextfields(new IPackageTextFieldVisitor(){

            @Override
            public void visit(EntityTextField txt, TargetPackageModel model) {
                String prefKey = DefaultTargetPackage.getPreferenceKey((String)model.m_id);
                modifiedProjects.add(model.m_context);
                if (model.m_defaultVal.equals(txt.getText())) {
                    model.m_context.getPreferences().remove(prefKey);
                } else {
                    model.m_context.getPreferences().put(prefKey, txt.getText());
                }
            }
        });
        for (IScoutBundle p : modifiedProjects) {
            try {
                p.getPreferences().flush();
            }
            catch (BackingStoreException ex) {
                ScoutSdkUi.logError("Unable to save new default package configuration for project '" + p.getSymbolicName() + "'.", ex);
            }
        }
    }

    @Override
    public void reset() {
        this.visitTextfields(new IPackageTextFieldVisitor(){

            @Override
            public void visit(EntityTextField txt, TargetPackageModel model) {
                txt.setText(model.m_defaultVal);
            }
        });
    }

    private void visitTextfields(IPackageTextFieldVisitor visitor) {
        int i = 0;
        while (i < this.m_entries.size()) {
            EntityTextField txt = this.m_allEntityTextFields.get(i);
            TargetPackageModel model = this.m_entries.get(i);
            visitor.visit(txt, model);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        ((GridData)this.m_scrollArea.getLayoutData()).exclude = !visible;
        this.m_scrollArea.setVisible(visible);
        this.m_scrollArea.reflow(true);
    }

    @Override
    public void reflow() {
        this.m_scrollArea.reflow(true);
    }

    @Override
    public void setSearchPattern(String pattern) {
        char[] searchPatternArray = pattern.toCharArray();
        int i = 0;
        while (i < this.m_allEntityTextFields.size()) {
            EntityTextField txt = this.m_allEntityTextFields.get(i);
            String curText = txt.getText();
            if (curText == null) {
                curText = "";
            }
            boolean visible = CharOperation.match((char[])searchPatternArray, (char[])curText.toCharArray(), (boolean)false) || CharOperation.match((char[])searchPatternArray, (char[])txt.getLabelText().toCharArray(), (boolean)false);
            txt.setVisible(visible);
            ((GridData)txt.getLayoutData()).exclude = !visible;
            Composite section = txt.getParent().getParent();
            if (section instanceof ExpandableComposite) {
                ((ExpandableComposite)section).setExpanded(true);
            }
            ++i;
        }
    }

    private static interface IPackageTextFieldVisitor {
        public void visit(EntityTextField var1, TargetPackageModel var2);
    }
}

