/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.model.IWorkbenchAdapter;

public final class TreeUtility {
    public static final String TYPE_PRODUCT_NODE = "zz_product_node";
    public static final String TYPE_PROJECT_NODE = "zz_project_node";

    private TreeUtility() {
    }

    public static ITreeNode[] findNodes(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        return collector.toArray(new ITreeNode[collector.size()]);
    }

    public static <T> boolean isOneOf(T toSearch, T ... listToSearchIn) {
        if (listToSearchIn != null && listToSearchIn.length > 0) {
            T[] TArray = listToSearchIn;
            int n = listToSearchIn.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                if (CompareUtility.equals(t, toSearch)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ITreeNode findNode(ITreeNode startNode, ITreeNodeFilter filter) {
        ArrayList<ITreeNode> collector = new ArrayList<ITreeNode>(3);
        TreeUtility.collectNodes(startNode, filter, collector);
        if (collector.size() > 0) {
            return collector.get(0);
        }
        return null;
    }

    private static void collectNodes(ITreeNode node, ITreeNodeFilter filter, List<ITreeNode> collector) {
        if (node != null) {
            if (filter.accept(node)) {
                collector.add(node);
            }
            for (ITreeNode childNode : node.getChildren()) {
                TreeUtility.collectNodes(childNode, filter, collector);
            }
        }
    }

    public static ITreeNode createBundleTree(IScoutBundle scoutProject, IScoutBundleFilter scoutBundleFilter) {
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        if (scoutProject == null) {
            return rootNode;
        }
        IScoutBundleFilter rootFilter = null;
        rootFilter = scoutBundleFilter == null ? ScoutBundleFilters.getRootBundlesFilter() : ScoutBundleFilters.getFilteredRootBundlesFilter((IScoutBundleFilter)scoutBundleFilter);
        Set rootBundles = scoutProject.getParentBundles(rootFilter, true);
        TreeUtility.recAddChildNodes(rootNode, rootBundles, scoutBundleFilter);
        return rootNode;
    }

    private static void recAddChildNodes(ITreeNode node, Set<? extends IScoutBundle> bundles, IScoutBundleFilter scoutBundleFilter) {
        for (IScoutBundle iScoutBundle : bundles) {
            ITreeNode childNode;
            if (scoutBundleFilter != null && !scoutBundleFilter.accept(iScoutBundle) || (childNode = TreeUtility.createBundleTreeNode(node, iScoutBundle)) == null) continue;
            TreeUtility.recAddChildNodes(childNode, iScoutBundle.getDirectChildBundles(), scoutBundleFilter);
        }
    }

    public static ITreeNode createBundleTreeNode(ITreeNode parent, IScoutBundle b) {
        return TreeUtility.createBundleTreeNode(parent, b, null);
    }

    public static ITreeNode createBundleTreeNode(ITreeNode parent, IScoutBundle b, ITreeNodeFilter filter) {
        ScoutBundleUiExtension uiExt = ScoutBundleExtensionPoint.getExtension(b);
        TreeNode childNode = null;
        if (uiExt != null) {
            childNode = new TreeNode(b.getType(), b.getSymbolicName(), b);
            childNode.setOrderNr(Integer.MAX_VALUE - Math.abs(uiExt.getOrderNumber()));
            if (filter != null && !filter.accept(childNode)) {
                return null;
            }
            childNode.setBold(false);
            ImageDescriptor icon = uiExt.getIcon();
            if (b.isBinary()) {
                icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
                childNode.setForeground(ScoutSdkUi.getDisplay().getSystemColor(17));
            }
            childNode.setImage(icon);
            parent.addChild(childNode);
            childNode.setParent(parent);
        }
        return childNode;
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img) {
        return TreeUtility.createNode(parentNode, type, name, img, 0);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, null);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr, Object data) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, data, true);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr, Object data, boolean bold) {
        return TreeUtility.createNode(parentNode, type, name, img, orderNr, data, true, true);
    }

    public static ITreeNode createNode(ITreeNode parentNode, String type, String name, ImageDescriptor img, int orderNr, Object data, boolean bold, boolean checkable) {
        TreeNode node = new TreeNode(type, name);
        node.setData(data);
        node.setOrderNr(orderNr);
        node.setImage(img);
        node.setBold(bold);
        node.setCheckable(checkable);
        node.setParent(parentNode);
        parentNode.addChild(node);
        return node;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isProductFileContainingBundles(IFile productFile, Set<? extends IScoutBundle> filter) {
        try {
            IScoutBundle b;
            ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
            Iterator<? extends IScoutBundle> iterator = filter.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!pfmh.ProductFile.existsDependency((b = iterator.next()).getSymbolicName()));
            return true;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Unable to parse product '" + productFile.getFullPath().toOSString() + "'.", e);
        }
        return false;
    }

    public static ITreeNode createProductFileTreeNode(ITreeNode parent, IFile file, ITreeNodeFilter filter, boolean checkable) {
        TreeNode productNode = new TreeNode(TYPE_PRODUCT_NODE, String.valueOf(file.getName()) + " (" + file.getParent().getName() + ")", file);
        if (filter != null && !filter.accept(productNode)) {
            return null;
        }
        productNode.setCheckable(checkable);
        productNode.setBold(true);
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)file.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter != null) {
            ImageDescriptor imageDescriptor = wbAdapter.getImageDescriptor((Object)file);
            productNode.setImage(imageDescriptor);
        }
        parent.addChild(productNode);
        productNode.setParent(parent);
        return productNode;
    }

    public static ITreeNode createProjectTreeNode(ITreeNode parent, IProject project, ITreeNodeFilter filter) {
        TreeNode childNode = new TreeNode(TYPE_PROJECT_NODE, project.getName(), project);
        if (filter != null && !filter.accept(childNode)) {
            return null;
        }
        childNode.setBold(false);
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter != null) {
            ImageDescriptor imageDescriptor = wbAdapter.getImageDescriptor((Object)project);
            childNode.setImage(imageDescriptor);
        }
        parent.addChild(childNode);
        childNode.setParent(parent);
        return childNode;
    }

    public static ITreeNode createProductTree(IScoutBundle project, ITreeNodeFilter visibleFilter, boolean checkMode) throws CoreException {
        if (project == null) {
            return null;
        }
        if (visibleFilter == null) {
            visibleFilter = NodeFilters.getAcceptAll();
        }
        Set containingScoutBundles = project.getChildBundles(ScoutBundleFilters.getAllBundlesFilter(), true);
        List productFiles = ResourceUtility.getAllResources((IResourceFilter)ResourceFilters.getProductFileFilter());
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        for (IResource res : productFiles) {
            IFile file = (IFile)res;
            if (!TreeUtility.isProductFileContainingBundles(file, containingScoutBundles)) continue;
            IProject fileProject = file.getProject();
            IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IProject)fileProject);
            ITreeNode bundleNode = null;
            if (bundle == null || ScoutBundleExtensionPoint.getExtension(bundle) == null) {
                bundleNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(fileProject));
                if (bundleNode == null) {
                    bundleNode = TreeUtility.createProjectTreeNode(rootNode, fileProject, visibleFilter);
                }
            } else {
                bundleNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(bundle));
                if (bundleNode == null) {
                    bundleNode = TreeUtility.createBundleTreeNode(rootNode, bundle, visibleFilter);
                }
            }
            if (bundleNode == null) continue;
            bundleNode.setCheckable(false);
            TreeUtility.createProductFileTreeNode(bundleNode, file, visibleFilter, checkMode);
        }
        return rootNode;
    }
}

