/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.buttongroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ui.fields.buttongroup.IButtonGroupListener;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ButtonGroup<T>
extends Composite {
    public static final int BUTTON_TYPE_RADIO = 16;
    public static final int BUTTON_TYPE_CHECK = 32;
    private static final String VALUE = "value";
    private List<Button> m_buttons;
    private final int m_type;
    private final EventListenerList m_eventListeners;
    private final P_ButtonSelectionListener m_internalListener = new P_ButtonSelectionListener();
    private final OptimisticLock m_notificationLock = new OptimisticLock();

    public ButtonGroup(Composite parent, int type) {
        super(parent, 0);
        if (type != 16 && type != 32) {
            throw new IllegalArgumentException("selection button type not valid");
        }
        this.m_eventListeners = new EventListenerList();
        this.m_buttons = new ArrayList<Button>();
        this.m_type = type;
        this.setLayout((Layout)new FormLayout());
    }

    public void addButtonGroupListener(IButtonGroupListener<T> listener) {
        this.m_eventListeners.add(IButtonGroupListener.class, listener);
    }

    public void removeButtonGroupListener(IButtonGroupListener<T> listener) {
        this.m_eventListeners.remove(IButtonGroupListener.class, listener);
    }

    public int getType() {
        return this.m_type;
    }

    public Button createButton(String label, T value) {
        Button newButton = new Button((Composite)this, this.m_type);
        newButton.setData(VALUE, value);
        newButton.setText(label);
        newButton.addSelectionListener((SelectionListener)this.m_internalListener);
        FormData formData = new FormData();
        if (this.m_buttons.size() > 0) {
            formData.top = new FormAttachment((Control)this.m_buttons.get(this.m_buttons.size() - 1), 10);
        }
        formData.left = new FormAttachment(20, 5);
        newButton.setLayoutData((Object)formData);
        this.m_buttons.add(newButton);
        return newButton;
    }

    public void setValue(T ... val) {
        HashSet<T> values = new HashSet<T>();
        if (val != null) {
            values.addAll(Arrays.asList(val));
        }
        if (this.getType() == 16 && values.size() > 1) {
            throw new IllegalArgumentException("BUTTON_TYPE_RADIO allows only one value to select.");
        }
        boolean dirty = false;
        try {
            this.m_notificationLock.acquire();
            for (Button b : this.m_buttons) {
                if (values.contains(b.getData(VALUE))) {
                    if (b.getSelection()) continue;
                    b.setSelection(true);
                    dirty = true;
                    continue;
                }
                if (!b.getSelection()) continue;
                b.setSelection(false);
                dirty = true;
            }
        }
        finally {
            this.m_notificationLock.release();
        }
        if (dirty) {
            this.fireSelectionChanged();
        }
    }

    public T getValue() {
        List<T> values = this.getValues();
        if (values.size() == 1) {
            return values.get(0);
        }
        if (values.size() == 0) {
            return null;
        }
        ScoutSdkUi.logWarning("get selected value of a radio button group. Should use the method getValues().");
        return values.get(0);
    }

    public List<T> getValues() {
        ArrayList<Object> selectedValues = new ArrayList<Object>(this.m_buttons.size());
        for (Button b : this.m_buttons) {
            if (!b.getSelection()) continue;
            selectedValues.add(b.getData(VALUE));
        }
        return selectedValues;
    }

    private void fireSelectionChanged() {
        List<T> selection = this.getValues();
        IButtonGroupListener[] iButtonGroupListenerArray = (IButtonGroupListener[])this.m_eventListeners.getListeners(IButtonGroupListener.class);
        int n = iButtonGroupListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IButtonGroupListener l = iButtonGroupListenerArray[n2];
            try {
                l.handleSelectionChanged(selection);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("error during listener notification.", e);
            }
            ++n2;
        }
    }

    private class P_ButtonSelectionListener
    extends SelectionAdapter {
        private int m_lastEvent = 0;

        private P_ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                if (ButtonGroup.this.m_notificationLock.acquire() && e.time != this.m_lastEvent) {
                    this.m_lastEvent = e.time;
                    ButtonGroup.this.fireSelectionChanged();
                }
            }
            finally {
                ButtonGroup.this.m_notificationLock.release();
            }
        }
    }
}

