/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.ISearchRangeConsumer;

public class StaticContentProvider
extends ContentProposalProvider {
    private Object[] m_elements;
    private final ILabelProvider m_labelProvider;

    public StaticContentProvider(Object[] elements, ILabelProvider labelProvider) {
        this.m_elements = elements;
        this.m_labelProvider = labelProvider;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        Object[] elements;
        if (!StringUtility.hasText((CharSequence)searchPattern)) {
            searchPattern = "*";
        }
        if ((elements = this.getElements()) == null) {
            return new Object[0];
        }
        ArrayList<Object> props = new ArrayList<Object>(elements.length);
        ISearchRangeConsumer searchRangeLabelProvider = null;
        boolean isFormatConcatString = false;
        if (this.getLabelProvider() instanceof ISearchRangeConsumer) {
            searchRangeLabelProvider = (ISearchRangeConsumer)this.getLabelProvider();
            searchRangeLabelProvider.startRecordMatchRegions();
            isFormatConcatString = searchRangeLabelProvider.isFormatConcatString();
        }
        ContentProposalProvider.NormalizedPattern normalizedPattern = StaticContentProvider.createNormalizedSearchPattern(searchPattern);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object prop = objectArray[n2];
            if (monitor.isCanceled()) break;
            int[] matchRegions = StaticContentProvider.getMatchingRegions(prop, this.getLabelProvider().getText(prop), normalizedPattern, isFormatConcatString);
            if (matchRegions != null) {
                props.add(prop);
            }
            if (searchRangeLabelProvider != null) {
                searchRangeLabelProvider.addMatchRegions(prop, matchRegions);
            }
            ++n2;
        }
        if (searchRangeLabelProvider != null) {
            searchRangeLabelProvider.endRecordMatchRegions();
        }
        return props.toArray(new Object[props.size()]);
    }

    public void setElements(Object[] elements) {
        this.m_elements = elements;
    }

    public Object[] getElements() {
        return this.m_elements;
    }

    public ILabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }
}

