/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.table;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.fields.table.IColumnProvider;
import org.eclipse.scout.sdk.ui.internal.fields.table.TableColumnProvider;
import org.eclipse.scout.sdk.ui.internal.fields.table.TreeColumnProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ColumnViewerFilter
extends Composite {
    private Button m_resetButton;
    private Text[] m_filterFields;
    private IColumnProvider m_columnProvider;
    private IColumnProvider.LayoutUpdateListener m_layoutUpdateListener = new IColumnProvider.LayoutUpdateListener(){

        @Override
        public void updateLayout() {
            ColumnViewerFilter.this.layout();
        }
    };

    public ColumnViewerFilter(Composite parent) {
        super(parent, 0x20000000);
        this.setBackground(parent.getBackground());
        this.m_resetButton = new Button((Composite)this, 0x800008);
        this.m_resetButton.setText("Reset");
        this.m_resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnViewerFilter.this.m_filterFields != null) {
                    Text[] textArray = ColumnViewerFilter.this.m_filterFields;
                    int n = textArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Text t = textArray[n2];
                        t.setText("");
                        ++n2;
                    }
                }
            }
        });
        this.updateFilterFields(this);
        this.setLayout(new P_FilterComponentLayout());
    }

    public void setViewer(ColumnViewer columnViewer) {
        if (this.m_columnProvider != null) {
            this.m_columnProvider.dispose();
        }
        if (columnViewer instanceof TableViewer) {
            this.m_columnProvider = new TableColumnProvider((TableViewer)columnViewer);
        } else if (columnViewer instanceof TreeViewer) {
            this.m_columnProvider = new TreeColumnProvider((TreeViewer)columnViewer);
        } else {
            throw new IllegalArgumentException("viewer must be instanceof TableViwer or TreeViewer");
        }
        this.m_columnProvider.addLayoutUpdateListener(this.m_layoutUpdateListener);
        this.updateFilterFields(this);
    }

    private void updateFilterFields(ColumnViewerFilter columnViewerFilter) {
        if (this.m_filterFields != null) {
            Text[] textArray = this.m_filterFields;
            int n = this.m_filterFields.length;
            int n2 = 0;
            while (n2 < n) {
                Text t = textArray[n2];
                t.dispose();
                ++n2;
            }
        }
        if (this.m_columnProvider != null) {
            this.m_filterFields = new Text[this.m_columnProvider.getColumnCount()];
            int i = 0;
            while (i < this.m_filterFields.length) {
                Text filterField = new Text((Composite)this, 2048);
                filterField.addModifyListener((ModifyListener)new P_FilterModifyListener(i));
                this.m_filterFields[i] = filterField;
                ++i;
            }
        }
    }

    private void handleFilterModified(int index) {
        if (this.m_columnProvider != null) {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
            ViewerFilter[] viewerFilterArray = this.m_columnProvider.getViewer().getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!(filter instanceof P_ViewerFilter)) {
                    filters.add(filter);
                }
                ++n2;
            }
            int i = 0;
            while (i < this.m_filterFields.length) {
                String text = this.m_filterFields[i].getText();
                if (!StringUtility.isNullOrEmpty((CharSequence)text)) {
                    filters.add(new P_ViewerFilter(text, i));
                }
                ++i;
            }
            try {
                this.m_columnProvider.getViewer().getControl().setRedraw(false);
                this.m_columnProvider.getViewer().setFilters(filters.toArray(new ViewerFilter[filters.size()]));
                this.m_columnProvider.expandAll();
            }
            finally {
                this.m_columnProvider.getViewer().getControl().setRedraw(true);
            }
        }
    }

    private class P_FilterComponentLayout
    extends Layout {
        private P_FilterComponentLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int height = ((ColumnViewerFilter)ColumnViewerFilter.this).m_resetButton.computeSize((int)-1, (int)hHint).y + 2;
            Text[] textArray = ColumnViewerFilter.this.m_filterFields;
            int n = textArray.length;
            int n2 = 0;
            while (n2 < n) {
                Text t = textArray[n2];
                height = Math.max(height, t.computeSize((int)-1, (int)hHint).y + 2);
                ++n2;
            }
            return new Point(wHint, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Point resetButtonSize = ColumnViewerFilter.this.m_resetButton.computeSize(-1, clientArea.height - 2);
            int w = clientArea.width;
            Rectangle buttonBounds = new Rectangle(-1, clientArea.y + 1, Math.min(clientArea.width, resetButtonSize.x), clientArea.height - 2);
            buttonBounds.x = clientArea.x + clientArea.width - buttonBounds.width - 2;
            ColumnViewerFilter.this.m_resetButton.setBounds(buttonBounds);
            w -= buttonBounds.width;
            if (ColumnViewerFilter.this.m_columnProvider != null) {
                int x = ColumnViewerFilter.this.m_columnProvider.getXOffset();
                int[] columnWidths = ColumnViewerFilter.this.m_columnProvider.getColumnWidths();
                int i = 0;
                while (i < columnWidths.length) {
                    Rectangle bounds = new Rectangle(x + 1, clientArea.y + 1, columnWidths[i] - 2, clientArea.height - 2);
                    if (bounds.x + bounds.width <= 0) {
                        ColumnViewerFilter.this.m_filterFields[i].setVisible(false);
                    } else if (w < 0) {
                        ColumnViewerFilter.this.m_filterFields[i].setVisible(false);
                    } else {
                        ColumnViewerFilter.this.m_filterFields[i].setVisible(true);
                        bounds.width = Math.min(w, bounds.width);
                        ColumnViewerFilter.this.m_filterFields[i].setBounds(bounds);
                    }
                    w -= bounds.width;
                    x += columnWidths[i];
                    ++i;
                }
            }
            composite.update();
        }
    }

    private class P_FilterModifyListener
    implements ModifyListener {
        private int m_columnIndex;

        public P_FilterModifyListener(int columnIndex) {
            this.m_columnIndex = columnIndex;
        }

        public void modifyText(ModifyEvent e) {
            ColumnViewerFilter.this.handleFilterModified(this.m_columnIndex);
        }
    }

    private class P_ViewerFilter
    extends ViewerFilter {
        private final String m_pattern;
        private final int m_columnIndex;
        private HashMap<Object, Boolean> m_visitedNodes;

        public P_ViewerFilter(String pattern, int columnIndex) {
            this.m_columnIndex = columnIndex;
            this.m_pattern = String.valueOf(pattern.toLowerCase()) + "*";
            this.m_visitedNodes = new HashMap();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.visitChildren(element);
        }

        private boolean visitChildren(Object node) {
            Object[] children;
            Boolean result = this.m_visitedNodes.remove(node);
            if (result == null) {
                String cellText = ColumnViewerFilter.this.m_columnProvider.getCellText(node, this.m_columnIndex);
                result = CharOperation.match((char[])this.m_pattern.toCharArray(), (char[])cellText.toCharArray(), (boolean)false);
                this.m_visitedNodes.put(node, result);
            }
            if (result.booleanValue()) {
                return true;
            }
            Object[] objectArray = children = ColumnViewerFilter.this.m_columnProvider.getChildren(node);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                result = this.visitChildren(child);
                if (result.booleanValue()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

