/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.License;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LicenseDialog
extends TitleAreaDialog {
    private final Map<String, License[]> m_iuToLicenses;
    private boolean m_complete;
    private TreeViewer m_iuViewer;
    private Text m_licenseTextBox;
    private Button m_acceptButton;
    private Button m_declineButton;
    private SashForm m_sashForm;

    public LicenseDialog(Shell parentShell, Map<String, License[]> iuToLicenses) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
        if (iuToLicenses == null) {
            this.m_iuToLicenses = Collections.emptyMap();
        } else {
            this.m_iuToLicenses = new LinkedHashMap<String, License[]>(iuToLicenses.size());
            for (Map.Entry<String, License[]> entry : iuToLicenses.entrySet()) {
                if (!StringUtility.hasText((CharSequence)entry.getKey()) || entry.getValue() == null || entry.getValue().length <= 0) continue;
                this.m_iuToLicenses.put(entry.getKey(), entry.getValue());
            }
        }
        this.m_complete = false;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.setMessage(Texts.get((String)"LicDialogMsg"));
        this.setTitle(Texts.get((String)"LicDialogTitle"));
        this.m_iuViewer.setSelection(this.m_iuViewer.getSelection(), true);
        return c;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonbar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.isComplete());
        return buttonbar;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_sashForm = new SashForm(parent, 256);
        this.m_sashForm.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.m_sashForm.setLayoutData((Object)gd);
        this.createLicenseListSection((Composite)this.m_sashForm);
        this.createLicenseContentSection((Composite)this.m_sashForm);
        return this.m_sashForm;
    }

    private void createLicenseContentSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(Texts.get((String)"LicDialogContentLabel"));
        this.m_licenseTextBox = new Text(composite, 2634);
        this.m_licenseTextBox.setBackground(this.m_licenseTextBox.getDisplay().getSystemColor(25));
        this.createLicenseAcceptSection(composite);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 450;
        gd.heightHint = 400;
        this.m_licenseTextBox.setLayoutData((Object)gd);
    }

    private void createLicenseListSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label label = new Label(composite, 0);
        label.setText(Texts.get((String)"LicDialogListLabel"));
        this.m_iuViewer = new TreeViewer(composite, 68352);
        this.m_iuViewer.setAutoExpandLevel(-1);
        this.m_iuViewer.setContentProvider((IContentProvider)new P_ContentProvider());
        this.m_iuViewer.setLabelProvider((IBaseLabelProvider)new P_LabelProvider());
        this.m_iuViewer.setComparator(new ViewerComparator());
        this.m_iuViewer.setInput(this.m_iuToLicenses);
        if (this.m_iuToLicenses != null && this.m_iuToLicenses.size() > 0) {
            for (License[] licenses : this.m_iuToLicenses.values()) {
                if (licenses == null || licenses.length <= 0) continue;
                this.m_iuViewer.setSelection((ISelection)new StructuredSelection((Object)licenses[0]), false);
                break;
            }
        }
        this.m_iuViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LicenseDialog.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 8;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.widthHint = 150;
        gd.heightHint = 400;
        this.m_iuViewer.getControl().setLayoutData((Object)gd);
    }

    private void createLicenseAcceptSection(Composite parent) {
        Composite buttonContainer = new Composite(parent, 0);
        this.m_acceptButton = new Button(buttonContainer, 16);
        this.m_acceptButton.setText(Texts.get((String)"LicDialogAcceptButton"));
        this.m_acceptButton.setSelection(false);
        this.m_acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.setComplete(LicenseDialog.this.m_acceptButton.getSelection());
            }
        });
        this.m_declineButton = new Button(buttonContainer, 16);
        this.m_declineButton.setText(Texts.get((String)"LicDialogDeclineButton"));
        this.m_declineButton.setSelection(true);
        this.m_declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseDialog.this.setComplete(!LicenseDialog.this.m_declineButton.getSelection());
            }
        });
        GridData gd = new GridData(256);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)gd);
    }

    private void handleSelectionChanged(IStructuredSelection selection) {
        Object selected;
        this.m_licenseTextBox.setText("");
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof License) {
            this.m_licenseTextBox.setText(((License)selected).getBody());
        }
    }

    public void setComplete(boolean complete) {
        this.m_complete = complete;
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getButton(0).setEnabled(complete);
        }
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    private class P_ContentProvider
    implements ITreeContentProvider {
        private P_ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return LicenseDialog.this.m_iuToLicenses.keySet().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (!(parentElement instanceof String)) {
                return new Object[0];
            }
            Object[] lics = (License[])LicenseDialog.this.m_iuToLicenses.get(parentElement);
            if (lics != null && lics.length > 0) {
                return lics;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof License) {
                License l = (License)element;
                return l.getInstallableUnitId();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return LicenseDialog.this.m_iuToLicenses.containsKey(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class P_LabelProvider
    extends LabelProvider {
        private P_LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof License) {
                return ((License)element).getTitle();
            }
            return "";
        }
    }
}

