/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.graphics.FontData;

public class SystemFonts {
    private Map<String, List<FontData>> m_fonts = new HashMap<String, List<FontData>>();

    public SystemFonts(FontData[] fontData) {
        if (fontData != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData d = fontDataArray[n2];
                List<FontData> set = this.m_fonts.get(d.getName());
                if (set == null) {
                    set = new ArrayList<FontData>();
                    this.m_fonts.put(d.getName(), set);
                }
                set.add(d);
                ++n2;
            }
        }
    }

    public Collection<String> getAllFontNames() {
        TreeMap<String, String> fontNames = new TreeMap<String, String>();
        for (String fontName : this.m_fonts.keySet()) {
            fontNames.put(fontName.toLowerCase(), fontName);
        }
        return fontNames.values();
    }

    public Set<Integer> getFontStyles(String fontName) {
        TreeSet<Integer> sizes = new TreeSet<Integer>();
        List<FontData> set = this.m_fonts.get(fontName);
        if (set != null) {
            for (FontData d : set) {
                sizes.add(d.getStyle());
            }
        }
        return sizes;
    }
}

