/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.IContextMenuContributor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.osgi.framework.Bundle;

public class ContextMenuContributorExtensionPoint {
    private static final Object LOCK = new Object();
    private static volatile List<IScoutHandler> contextMenuExtensions;
    private static volatile List<MenuContributionInfo> contextMenuContributorExtensions;
    private static volatile Map<IScoutHandler.Category, List<IScoutHandler>> contextMenuByCat;

    public static List<IContextMenuContributor> getContextMenuContributors(Object o) {
        List<MenuContributionInfo> contributors = ContextMenuContributorExtensionPoint.getContributors();
        ArrayList<IContextMenuContributor> ret = new ArrayList<IContextMenuContributor>(contributors.size());
        for (MenuContributionInfo i : contributors) {
            if (o != null && i.pageClassFilter != null && !i.pageClassFilter.isAssignableFrom(o.getClass())) continue;
            ret.add(i.contributor);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MenuContributionInfo> getContributors() {
        if (contextMenuContributorExtensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (contextMenuContributorExtensions == null) {
                    final ArrayList list = new ArrayList();
                    ContextMenuContributorExtensionPoint.visitExtensions("contextMenuContributor", "contributor", new IExtensionVisitor(){

                        @Override
                        public boolean visit(IConfigurationElement element) {
                            try {
                                String contribPlugin;
                                Bundle bundle;
                                IContextMenuContributor ext = (IContextMenuContributor)element.createExecutableExtension("class");
                                String pageClassName = StringUtility.trim((String)element.getAttribute("page"));
                                Class clazz = null;
                                if (!StringUtility.isNullOrEmpty((CharSequence)pageClassName) && (bundle = Platform.getBundle((String)(contribPlugin = element.getContributor().getName()))) != null) {
                                    clazz = bundle.loadClass(pageClassName);
                                }
                                MenuContributionInfo info = new MenuContributionInfo(ext, clazz);
                                list.add(info);
                            }
                            catch (Exception t) {
                                ScoutSdkUi.logError("create context menu contributor: " + element.getAttribute("class"), t);
                            }
                            return true;
                        }
                    });
                    Collections.sort(list, new Comparator<MenuContributionInfo>(){

                        @Override
                        public int compare(MenuContributionInfo o1, MenuContributionInfo o2) {
                            return o1.contributor.getClass().getSimpleName().compareTo(o2.contributor.getClass().getSimpleName());
                        }
                    });
                    contextMenuContributorExtensions = CollectionUtility.arrayList(list);
                }
            }
        }
        return contextMenuContributorExtensions;
    }

    private static void visitExtensions(String extensionPointName, String elementName, IExtensionVisitor v) {
        IExtension[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionPointName);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (elementName.equals(element.getName()) && !v.visit(element)) {
                    return;
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IScoutHandler> getAllRegisteredContextMenus() {
        if (contextMenuExtensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (contextMenuExtensions == null) {
                    final ArrayList list = new ArrayList();
                    ContextMenuContributorExtensionPoint.visitExtensions("contextMenu", "contextMenu", new IExtensionVisitor(){

                        @Override
                        public boolean visit(IConfigurationElement element) {
                            try {
                                IScoutHandler ext = (IScoutHandler)element.createExecutableExtension("class");
                                list.add(ext);
                            }
                            catch (Exception t) {
                                ScoutSdkUi.logError("Unable to create context menu: " + element.getAttribute("class"), t);
                            }
                            return true;
                        }
                    });
                    contextMenuExtensions = CollectionUtility.arrayList(list);
                }
            }
        }
        return CollectionUtility.arrayList(contextMenuExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<IScoutHandler.Category, List<IScoutHandler>> getAllRegisteredContextMenusByCategory() {
        if (contextMenuByCat == null) {
            Object object = LOCK;
            synchronized (object) {
                if (contextMenuByCat == null) {
                    TreeMap<IScoutHandler.Category, List<IScoutHandler>> sorted = new TreeMap<IScoutHandler.Category, List<IScoutHandler>>(new Comparator<IScoutHandler.Category>(){

                        @Override
                        public int compare(IScoutHandler.Category o1, IScoutHandler.Category o2) {
                            return Integer.valueOf(o1.getOrder()).compareTo(o2.getOrder());
                        }
                    });
                    for (IScoutHandler a : ContextMenuContributorExtensionPoint.getAllRegisteredContextMenus()) {
                        List<IScoutHandler> listOfCurCat = sorted.get((Object)a.getCategory());
                        if (listOfCurCat == null) {
                            listOfCurCat = new LinkedList<IScoutHandler>();
                            sorted.put(a.getCategory(), listOfCurCat);
                        }
                        listOfCurCat.add(a);
                    }
                    contextMenuByCat = sorted;
                }
            }
        }
        return new TreeMap<IScoutHandler.Category, List<IScoutHandler>>(contextMenuByCat);
    }

    private static interface IExtensionVisitor {
        public boolean visit(IConfigurationElement var1);
    }

    private static class MenuContributionInfo {
        private IContextMenuContributor contributor;
        private Class<? extends IPage> pageClassFilter;

        public MenuContributionInfo(IContextMenuContributor c, Class<? extends IPage> p) {
            this.contributor = c;
            this.pageClassFilter = p;
        }
    }
}

