/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class ServerScoutBundleExtension
implements INewScoutBundleHandler {
    public static final String ID = "org.eclipse.scout.sdk.ui.ServerBundle";

    @Override
    public void init(IScoutProjectWizard wizard, ScoutBundleUiExtension extension) {
        IScoutBundle selected = wizard.getScoutProject();
        boolean available = selected == null || selected.hasType("SERVER") || selected.hasType("SHARED");
        wizard.getProjectWizardPage().setBundleNodeAvailable(available, available, ID);
    }

    @Override
    public IStatus getStatus(IScoutProjectWizard wizard) {
        IScoutBundle selected = wizard.getScoutProject();
        if (selected == null && !wizard.getProjectWizardPage().hasSelectedBundle("SHARED")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "A server bundle without a shared bundle can not be created.");
        }
        return Status.OK_STATUS;
    }

    @Override
    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
    }

    @Override
    public void putProperties(IScoutProjectWizard wizard, PropertyMap properties) {
        IScoutBundle server;
        IScoutBundle selected = wizard.getScoutProject();
        if (selected != null && (server = selected.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), true)) != null && server.getJavaProject() != null) {
            properties.setProperty("BUNDLE_SERVER_NAME", (Object)server.getProject().getName());
            ((List)properties.getProperty("CREATED_BUNDLES", List.class)).add(server.getJavaProject());
        }
    }
}

