/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class SharedScoutBundleExtension
implements INewScoutBundleHandler {
    public static final String ID = "org.eclipse.scout.sdk.ui.SharedBundle";

    @Override
    public void init(IScoutProjectWizard wizard, ScoutBundleUiExtension extension) {
        IScoutBundle selected = wizard.getScoutProject();
        boolean available = selected == null || selected.hasType("SHARED");
        wizard.getProjectWizardPage().setBundleNodeAvailable(available, available, ID);
    }

    @Override
    public IStatus getStatus(IScoutProjectWizard wizard) {
        if (!wizard.getProjectWizardPage().hasSelectedBundle("CLIENT", "SERVER")) {
            return new Status(2, "org.eclipse.scout.sdk.ui", "Be aware of creating a shared bundle without a client or server bundle.");
        }
        return Status.OK_STATUS;
    }

    @Override
    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
    }

    @Override
    public void putProperties(IScoutProjectWizard wizard, PropertyMap properties) {
        IScoutBundle shared;
        IScoutBundle selected = wizard.getScoutProject();
        if (selected != null && (shared = selected.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), true)) != null && shared.getJavaProject() != null) {
            properties.setProperty("BUNDLE_SHARED_NAME", (Object)shared.getProject().getName());
            ((List)properties.getProperty("CREATED_BUNDLES", List.class)).add(shared.getJavaProject());
        }
    }
}

