/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class SwtScoutBundleExtension
implements INewScoutBundleHandler {
    public static final String ID = "org.eclipse.scout.sdk.ui.UiSwtBundle";

    @Override
    public void init(IScoutProjectWizard wizard, ScoutBundleUiExtension extension) {
        IScoutBundle selected = wizard.getScoutProject();
        boolean available = selected == null || selected.hasType("UI_SWT") || selected.hasType("CLIENT");
        wizard.getProjectWizardPage().setBundleNodeAvailable(available, available, ID);
    }

    @Override
    public IStatus getStatus(IScoutProjectWizard wizard) {
        IScoutBundle selected = wizard.getScoutProject();
        if (selected == null && !wizard.getProjectWizardPage().hasSelectedBundle("CLIENT")) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoSwtWithoutAClient"));
        }
        return Status.OK_STATUS;
    }

    @Override
    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
    }

    @Override
    public void putProperties(IScoutProjectWizard wizard, PropertyMap properties) {
        IScoutBundle uiSwt;
        IScoutBundle selected = wizard.getScoutProject();
        if (selected != null && (uiSwt = selected.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"UI_SWT"}), true)) != null && uiSwt.getJavaProject() != null) {
            properties.setProperty("BUNDLE_SWT_NAME", (Object)uiSwt.getProject().getName());
            ((List)properties.getProperty("CREATED_BUNDLES", List.class)).add(uiSwt.getJavaProject());
        }
    }
}

