/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.project.template;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.extensions.project.template.IProjectTemplate;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.project.template.ProjectTemplateExtension;

public final class ProjectTemplateExtensionPoint {
    public static final String EXTENSION_ID = "scoutProjectTemplate";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_ORDER_NUMBER = "orderNumber";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_ICON = "icon";
    private static final Object LOCK = new Object();
    private static volatile Set<ProjectTemplateExtension> templateExtensions;

    private ProjectTemplateExtensionPoint() {
    }

    private static Set<ProjectTemplateExtension> initTemplates() {
        IExtension[] extensions;
        TreeSet<ProjectTemplateExtension> result = new TreeSet<ProjectTemplateExtension>(new P_ExtensionComparator());
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_ID);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                ProjectTemplateExtension extensionPoint = new ProjectTemplateExtension();
                extensionPoint.setExtensionId(element.getAttribute(ATTRIBUTE_ID));
                try {
                    extensionPoint.setTemplate((IProjectTemplate)element.createExecutableExtension(ATTRIBUTE_CLASS));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("could not load class '" + element.getAttribute(ATTRIBUTE_CLASS) + "'.", e);
                }
                extensionPoint.setIconPath(element.getAttribute(ATTRIBUTE_ICON));
                String attOrderNr = element.getAttribute(ATTRIBUTE_ORDER_NUMBER);
                try {
                    extensionPoint.setOrderNr(Long.parseLong(attOrderNr));
                }
                catch (NumberFormatException e) {
                    ScoutSdkUi.logError("could not parse order number '" + attOrderNr + "' of extension '" + element.getNamespaceIdentifier() + "'.", e);
                }
                if (extensionPoint.isValidConfiguration()) {
                    result.add(extensionPoint);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ProjectTemplateExtension> getTemplates() {
        if (templateExtensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (templateExtensions == null) {
                    templateExtensions = ProjectTemplateExtensionPoint.initTemplates();
                }
            }
        }
        return templateExtensions;
    }

    public static List<ProjectTemplateExtension> getExtensions() {
        return CollectionUtility.arrayList(ProjectTemplateExtensionPoint.getTemplates());
    }

    private static final class P_ExtensionComparator
    implements Comparator<ProjectTemplateExtension>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private P_ExtensionComparator() {
        }

        @Override
        public int compare(ProjectTemplateExtension o1, ProjectTemplateExtension o2) {
            int diff;
            if (o1.getOrderNr() != o2.getOrderNr() && (diff = (int)(o1.getOrderNr() - o2.getOrderNr())) != 0) {
                return diff;
            }
            return o1.getExtensionId().compareTo(o2.getExtensionId());
        }
    }
}

