/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology.svg;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class SvgClientTechnologyHandler
extends AbstractScoutTechnologyHandler {
    public static final String[] SCOUT_ONLY_SVG_PLUGINS = new String[]{"org.apache.batik.bridge", "org.apache.batik.dom", "org.apache.batik.dom.svg", "org.apache.batik.ext.awt", "org.apache.batik.parser", "org.apache.batik.svggen", "org.apache.batik.swing", "org.apache.batik.transcoder", "org.apache.batik.xml", "org.eclipse.scout.svg.client"};
    public static final String[] CORE_SVG_PLUGINS = new String[]{"org.apache.batik.css", "org.apache.batik.util", "org.apache.batik.util.gui", "org.w3c.dom.svg", "org.w3c.dom.smil", "org.w3c.css.sac"};
    private static final String[] BATIK_17_CORE_SVG_PLUGINS = new String[]{"org.w3c.dom.events"};
    private static final String[] BATIK_17_SCOUT_ONLY_SVG_PLUGINS = new String[]{"org.eclipse.scout.org.w3c.dom.svg.fragment"};

    public static String[] getAdditionalBatik17ScoutPlugins() {
        if (JdtUtility.isBatik17OrNewer()) {
            return Arrays.copyOf(BATIK_17_SCOUT_ONLY_SVG_PLUGINS, BATIK_17_SCOUT_ONLY_SVG_PLUGINS.length);
        }
        return null;
    }

    public static String[] getAdditionalBatik17CorePlugins() {
        if (JdtUtility.isBatik17OrNewer()) {
            return Arrays.copyOf(BATIK_17_CORE_SVG_PLUGINS, BATIK_17_CORE_SVG_PLUGINS.length);
        }
        return null;
    }

    @Override
    public void selectionChanged(Set<IScoutTechnologyResource> resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.selectionChangedManifest(resources, selected, "org.eclipse.scout.svg.client");
        this.selectionChangedManifestImportPackage(resources, selected, new String[]{"org.w3c.dom.svg"}, new String[]{"[1.1.0,2.0.0)"});
    }

    @Override
    public boolean isActive(IScoutBundle project) {
        return project.getChildBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), false) != null;
    }

    @Override
    public TriState getSelection(IScoutBundle project) {
        Set<? extends IScoutBundle> clientBundlesBelow = this.getClientBundlesBelow(project);
        TriState t1 = this.getSelectionManifests(clientBundlesBelow, "org.eclipse.scout.svg.client");
        TriState t2 = this.getSelectionManifestsImportPackage(clientBundlesBelow, "org.w3c.dom.svg");
        if (t1.equals((Object)t2)) {
            return t1;
        }
        return TriState.UNDEFINED;
    }

    @Override
    protected void contributeResources(IScoutBundle project, List<IScoutTechnologyResource> list) {
        this.contributeManifestFiles(this.getClientBundlesBelow(project), list);
    }

    private Set<? extends IScoutBundle> getClientBundlesBelow(IScoutBundle start) {
        return start.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), true);
    }
}

