/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.dnd;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.scout.sdk.ui.action.dnd.FormFieldRelocateAction;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.AbstractBoxNodePage;
import org.eclipse.scout.sdk.ui.view.outline.OutlineDropTargetEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.client.ui.form.field.AbstractFormFieldNodePage;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class FormFieldDropTargetDelegator
implements IDropTargetDelegator {
    @Override
    public boolean validateDrop(OutlineDropTargetEvent event) {
        AbstractScoutTypePage selectedPage;
        AbstractScoutTypePage targetPage;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.getTransferData())) break block7;
                            return false;
                        }
                        catch (Exception e) {
                            ScoutSdkUi.logWarning("could not validate drop location.", e);
                            return false;
                        }
                    }
                    targetPage = this.getGroupBoxTargetType(event);
                    if (targetPage == null) {
                        targetPage = this.getFormFieldTargetType(event);
                    }
                    if (targetPage != null) break block8;
                    return false;
                }
                selectedPage = this.getSelectedPage(event);
                if (selectedPage != null) break block9;
                return false;
            }
            if (this.isValidTargetLocation(event, targetPage, selectedPage)) break block10;
            return false;
        }
        return !this.isCopyAndSourceComplexAndTargetSameIcu(event, targetPage.getType(), selectedPage.getType());
    }

    private AbstractBoxNodePage getGroupBoxTargetType(OutlineDropTargetEvent event) {
        if (event.getCurrentTarget() instanceof AbstractBoxNodePage) {
            AbstractBoxNodePage targetPage = (AbstractBoxNodePage)event.getCurrentTarget();
            if (event.getCurrentLocation() != 3 && targetPage.getType().getElementName().equals("MainBox")) {
                return null;
            }
            return targetPage;
        }
        return null;
    }

    private AbstractFormFieldNodePage getFormFieldTargetType(OutlineDropTargetEvent event) {
        if (event.getCurrentTarget() instanceof AbstractFormFieldNodePage) {
            if (event.getCurrentLocation() == 3) {
                return null;
            }
            return (AbstractFormFieldNodePage)event.getCurrentTarget();
        }
        return null;
    }

    private AbstractScoutTypePage getSelectedPage(OutlineDropTargetEvent event) {
        if (event.getSelectedObject() instanceof AbstractBoxNodePage) {
            return (AbstractBoxNodePage)event.getSelectedObject();
        }
        if (event.getSelectedObject() instanceof AbstractFormFieldNodePage) {
            return (AbstractFormFieldNodePage)event.getSelectedObject();
        }
        return null;
    }

    private boolean isValidTargetLocation(OutlineDropTargetEvent event, AbstractScoutTypePage targetPage, AbstractScoutTypePage selectedPage) {
        if (event.getOperation() == 2) {
            if (targetPage.equals(selectedPage)) {
                return false;
            }
            if (targetPage.getParent().equals(selectedPage.getParent())) {
                List<IPage> children = targetPage.getParent().getChildren();
                int selectedIndex = children.indexOf(selectedPage);
                if (selectedIndex < 0) {
                    ScoutSdkUi.logError("could not find child index of selected node.");
                    return false;
                }
                if (event.getCurrentLocation() == 2 ? selectedIndex > 0 && children.get(selectedIndex - 1).equals(targetPage) : event.getCurrentLocation() == 1 && selectedIndex < children.size() - 1 && children.get(selectedIndex + 1).equals(targetPage)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isCopyAndSourceComplexAndTargetSameIcu(OutlineDropTargetEvent event, IType targetType, IType selectedType) {
        return event.getOperation() == 1 && selectedType.getCompilationUnit().equals(targetType.getCompilationUnit()) && ScoutTypeUtility.getFormFields((IType)selectedType).size() > 0;
    }

    @Override
    public boolean expand(OutlineDropTargetEvent event) {
        return !(event.getCurrentTarget() instanceof AbstractFormFieldNodePage);
    }

    @Override
    public boolean performDrop(OutlineDropTargetEvent event) {
        if (event.getOperation() == 1 || event.getOperation() == 2) {
            AbstractScoutTypePage sourcePage = (AbstractScoutTypePage)event.getSelectedObject();
            AbstractScoutTypePage targetPage = (AbstractScoutTypePage)event.getCurrentTarget();
            FormFieldRelocateAction action = new FormFieldRelocateAction(sourcePage.getType(), sourcePage.getOutlineView().getSite().getShell());
            action.setCreateCopy(event.getOperation() == 1);
            action.setLocation(this.dndToMoveOperationLocation(event.getCurrentLocation()));
            if (event.getCurrentLocation() == 3) {
                action.setTargetDeclaringType(targetPage.getType());
            } else {
                action.setTargetDeclaringType(targetPage.getType().getDeclaringType());
                action.setNeighborField(targetPage.getType());
            }
            action.run();
        }
        return true;
    }

    private int dndToMoveOperationLocation(int location) {
        switch (location) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 3;
    }
}

