/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.internal.workspace.ScoutWorkspace;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutProjectNewAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverFormDataAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverPageDataAction;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.BundleNodeGroupTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleTreeModel;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutExplorerSettingsBundleFilter;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutWorkingSetTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ProjectsTablePage
extends AbstractPage {
    private final IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void workspaceChanged(ScoutWorkspaceEvent event) {
            switch (event.getType()) {
                case 1: 
                case 2: 
                case 3: {
                    ProjectsTablePage.this.markStructureDirty();
                }
            }
        }
    };
    private final IPropertyChangeListener m_explorerConfigChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.scout.sdk.ui.view.scoutExplorer.bundleDisplayStyle".equals(event.getProperty()) || "org.eclipse.scout.sdk.view.ui.scoutExplorer.showFragments".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.showBinaryBundles".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenBundleTypes".equals(event.getProperty())) {
                ProjectsTablePage.this.markStructureDirty();
            } else if (("org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenWorkingSets".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.workingSetsOrder".equals(event.getProperty())) && ScoutExplorerSettingsSupport.BundlePresentation.WORKING_SET.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                ProjectsTablePage.this.markStructureDirty();
            }
        }
    };
    private final IPropertyChangeListener m_workingSetConfigChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (ScoutExplorerSettingsSupport.BundlePresentation.WORKING_SET.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                ProjectsTablePage.this.markStructureDirty();
            }
        }
    };

    public ProjectsTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"RootNodeName"));
        ScoutSdkCore.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
        ScoutSdkUi.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_explorerConfigChangeListener);
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.m_workingSetConfigChangeListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdkCore.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
        ScoutSdkUi.getDefault().getPreferenceStore().removePropertyChangeListener(this.m_explorerConfigChangeListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.m_workingSetConfigChangeListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ProjectsTablePage";
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache) {
            ScoutWorkspace.getInstance().rebuildGraph();
        } else {
            super.refresh(clearCache);
        }
    }

    @Override
    protected void loadChildrenImpl() {
        if (ScoutExplorerSettingsSupport.BundlePresentation.FLAT.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            Set allBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutExplorerSettingsBundleFilter.get(), ScoutBundleComparators.getSymbolicNameAscComparator());
            for (IScoutBundle b : allBundles) {
                ProjectsTablePage.createBundlePage(this, b);
            }
        } else if (ScoutExplorerSettingsSupport.BundlePresentation.HIERARCHICAL.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            for (IScoutBundle root : ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getFilteredRootBundlesFilter((IScoutBundleFilter)ScoutExplorerSettingsBundleFilter.get()), ScoutBundleComparators.getSymbolicNameAscComparator())) {
                ProjectsTablePage.createBundlePage(this, root);
            }
        } else if (ScoutExplorerSettingsSupport.BundlePresentation.WORKING_SET.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            IWorkingSet[] iWorkingSetArray = ScoutExplorerSettingsSupport.get().getScoutWorkingSets(false);
            int n = iWorkingSetArray.length;
            int b = 0;
            while (b < n) {
                IWorkingSet ws = iWorkingSetArray[b];
                new ScoutWorkingSetTablePage(this, ws);
                ++b;
            }
        } else {
            ScoutBundleTreeModel uiModel = new ScoutBundleTreeModel();
            uiModel.build();
            if (ScoutExplorerSettingsSupport.BundlePresentation.FLAT_GROUPS.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                HashSet<ScoutBundleNodeGroup> collector = new HashSet<ScoutBundleNodeGroup>();
                this.collectAllBundleGroupsRec(collector, uiModel.getRoots());
                for (ScoutBundleNodeGroup g : collector) {
                    new BundleNodeGroupTablePage(this, g);
                }
            } else {
                ScoutBundleNodeGroup[] scoutBundleNodeGroupArray = uiModel.getRoots();
                int n = scoutBundleNodeGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoutBundleNodeGroup g = scoutBundleNodeGroupArray[n2];
                    new BundleNodeGroupTablePage(this, g);
                    ++n2;
                }
            }
        }
    }

    private void collectAllBundleGroupsRec(Set<ScoutBundleNodeGroup> collector, ScoutBundleNodeGroup[] groups) {
        ScoutBundleNodeGroup[] scoutBundleNodeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleNodeGroup g = scoutBundleNodeGroupArray[n2];
            collector.add(g);
            this.collectAllBundleGroupsRec(collector, g.getChildGroups().toArray(new ScoutBundleNodeGroup[g.getChildGroups().size()]));
            ++n2;
        }
    }

    public static void createBundlePage(IPage parentPage, IScoutBundle b) {
        ScoutBundleUiExtension childExt;
        if (b != null && (childExt = ScoutBundleExtensionPoint.getExtension(b)) != null) {
            ScoutBundleNode rootNode = new ScoutBundleNode(b, childExt);
            rootNode.createBundlePage(parentPage);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(ScoutProjectNewAction.class, TypeResolverFormDataAction.class, TypeResolverPageDataAction.class, WellformAction.class);
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

