/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ClassIdNewAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.dto.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverPageDataAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.AbstractBundleNodeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientLookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopExtensionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.TemplateTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.SearchFormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.AllPagesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ClientNodePage
extends AbstractBundleNodeTablePage {
    private ICachedTypeHierarchy m_clientSessionHierarchy;
    private ICachedTypeHierarchy m_desktopHierarchy;
    private ICachedTypeHierarchy m_desktopExtensionHierarchy;

    public ClientNodePage(IPage parent, ScoutBundleNode node) {
        super(parent, node);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientNodePage";
    }

    @Override
    public void unloadPage() {
        if (this.m_desktopHierarchy != null) {
            this.m_desktopHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_desktopHierarchy = null;
        }
        if (this.m_desktopExtensionHierarchy != null) {
            this.m_desktopExtensionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_desktopExtensionHierarchy = null;
        }
        if (this.m_clientSessionHierarchy != null) {
            this.m_clientSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_clientSessionHierarchy = null;
        }
    }

    @Override
    protected void loadChildrenImpl() {
        IType iClientSession;
        super.loadChildrenImpl();
        IType iDesktop = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktop");
        IType iDesktopExtension = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension");
        if (this.m_clientSessionHierarchy == null && TypeUtility.exists((IJavaElement)(iClientSession = TypeUtility.getType((String)"org.eclipse.scout.rt.client.IClientSession")))) {
            this.m_clientSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iClientSession);
            this.m_clientSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_desktopHierarchy == null && TypeUtility.exists((IJavaElement)iDesktop)) {
            this.m_desktopHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iDesktop);
            this.m_desktopHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_desktopExtensionHierarchy == null && TypeUtility.exists((IJavaElement)iDesktopExtension)) {
            this.m_desktopExtensionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iDesktopExtension);
            this.m_desktopExtensionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        Set clientSessions = ScoutTypeUtility.getClientSessionTypes((IScoutBundle)this.getScoutBundle());
        for (IType clientSession : clientSessions) {
            new ClientSessionNodePage(this, clientSession);
        }
        if (this.m_desktopHierarchy != null) {
            Set desktops = this.m_desktopHierarchy.getAllSubtypes(iDesktop, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()));
            if (desktops.size() > 1) {
                ScoutSdkUi.logWarning("more than one desktop found.");
            }
            for (IType desktop : desktops) {
                new DesktopNodePage(this, desktop);
            }
        }
        if (this.m_desktopExtensionHierarchy != null) {
            Set desktopExtensions = this.m_desktopExtensionHierarchy.getAllSubtypes(iDesktopExtension, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()));
            for (IType desktopExtension : desktopExtensions) {
                new DesktopExtensionNodePage(this, desktopExtension);
            }
        }
        new FormTablePage(this);
        new SearchFormTablePage(this);
        new WizardTablePage(this);
        try {
            new ClientLookupCallTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not load LocalLookupCallTablePage.", e);
        }
        new ClientServiceTablePage(this);
        new OutlineTablePage(this);
        new AllPagesTablePage(this);
        new TemplateTablePage(this);
        try {
            new LibrariesTablePage(this, this.getScoutBundle());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(WellformAction.class, MultipleUpdateFormDataAction.class, ScoutBundleNewAction.class, TypeResolverPageDataAction.class, ClassIdNewAction.class);
    }
}

