/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.ClientServiceNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class ClientServiceTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_servieHierarchy;

    public ClientServiceTablePage(IPage parentPage) {
        this.setParent(parentPage);
        this.setName(Texts.get((String)"ClientServicesNodePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_servieHierarchy != null) {
            this.m_servieHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_servieHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_servieHierarchy != null) {
            this.m_servieHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        if (this.m_servieHierarchy == null) {
            this.m_servieHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
            this.m_servieHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        Set serviceTypes = this.m_servieHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()), TypeComparators.getTypeNameComparator());
        for (IType type : serviceTypes) {
            Set interfaces = this.m_servieHierarchy.getSuperInterfaces(type, TypeFilters.getElementNameFilter((String)("I" + type.getElementName())));
            new ClientServiceNodePage(this, type, (IType)CollectionUtility.firstElement((Collection)interfaces));
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(ClientServiceNewAction.class);
    }
}

