/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.KeyStrokeNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class KeyStrokeTablePage
extends AbstractPage {
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_keystrokeChangedListener;

    public KeyStrokeTablePage(IPage parentPage, IType declaringType) {
        this.m_declaringType = declaringType;
        this.setName(Texts.get((String)"KeyStrokesTablePage"));
        this.setParent(parentPage);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("keystrokes.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.KeyStrokeTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_keystrokeChangedListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
            this.m_keystrokeChangedListener = null;
        }
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_keystrokeChangedListener == null) {
            IType iKeyStrokeType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
            this.m_keystrokeChangedListener = new InnerTypePageDirtyListener(this, iKeyStrokeType);
            ScoutSdkCore.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
        }
        for (IType keyStroke : ScoutTypeUtility.getKeyStrokes((IType)this.getDeclaringType())) {
            KeyStrokeNodePage childPage = new KeyStrokeNodePage();
            childPage.setParent(this);
            childPage.setType(keyStroke);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(KeyStrokeNewAction.class);
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

