/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.MenuNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class MenuTablePage
extends AbstractPage {
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuTablePage(IPage parentPage, IType menuDeclaringType) {
        this.m_declaringType = menuDeclaringType;
        this.setParent(parentPage);
        this.setName(Texts.get((String)"MenuTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_menuChangedListener == null) {
            IType iMenuType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, iMenuType);
            ScoutSdkCore.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        Set menues = ScoutTypeUtility.getMenus((IType)this.getDeclaringType());
        for (IType menu : menues) {
            new MenuNodePage(this, menu);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(MenuNewAction.class);
    }
}

