/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.ui.view.outline.pages.PageFilter;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class PageFilterPresenter
extends AbstractPresenter {
    private Text m_filterExpressionField;
    private Button m_regexButton;
    private ImageHyperlink m_resetFilter;
    private final IPage m_page;

    public PageFilterPresenter(PropertyViewFormToolkit toolkit, Composite parent, IPage page) {
        super(toolkit, parent);
        this.m_page = page;
        this.createContent(this.getContainer());
    }

    protected void createContent(Composite container) {
        IPageFilter pageFilter;
        this.m_filterExpressionField = this.getToolkit().createText(container, "", 2048);
        this.m_resetFilter = this.getToolkit().createImageHyperlink(container, 8);
        this.m_resetFilter.setImage(ScoutSdkUi.getImage("delete.gif"));
        this.m_regexButton = this.getToolkit().createButton(container, Texts.get((String)"Regex"), 32);
        this.m_filterExpressionField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GridData gd = (GridData)PageFilterPresenter.this.m_resetFilter.getLayoutData();
                boolean emptyText = StringUtility.isNullOrEmpty((CharSequence)PageFilterPresenter.this.m_filterExpressionField.getText());
                PageFilterPresenter.this.m_resetFilter.setVisible(!emptyText);
                gd.exclude = emptyText;
                PageFilterPresenter.this.updateFilter();
                PageFilterPresenter.this.getContainer().layout(true);
            }
        });
        this.m_resetFilter.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PageFilterPresenter.this.m_filterExpressionField.setText("");
                PageFilterPresenter.this.updateFilter();
            }
        });
        this.m_regexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFilterPresenter.this.updateFilter();
            }
        });
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.m_filterExpressionField.setLayoutData((Object)data);
        data = new GridData(1040);
        data.exclude = true;
        this.m_resetFilter.setLayoutData((Object)data);
        data = new GridData(1040);
        this.m_regexButton.setLayoutData((Object)data);
        if (this.getPage() != null && this.getPage().getOutlineView() != null && (pageFilter = this.getPage().getOutlineView().getPageFilter(this.getPage())) != null && pageFilter instanceof PageFilter) {
            this.m_filterExpressionField.setText(pageFilter.getFilterExpression());
            this.m_regexButton.setSelection(((PageFilter)pageFilter).isRegExFilter());
        }
    }

    private void updateFilter() {
        PageFilter filter = null;
        if (!StringUtility.isNullOrEmpty((CharSequence)this.m_filterExpressionField.getText())) {
            filter = new PageFilter();
            filter.setFilterExpression(this.m_filterExpressionField.getText());
            filter.setRegExFilter(this.m_regexButton.getSelection());
        }
        this.getPage().getOutlineView().addPageFilter(this.getPage(), filter);
    }

    public IPage getPage() {
        return this.m_page;
    }
}

