/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.BigIntegerPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class BigIntegerPresenter
extends AbstractValuePresenter<BigInteger> {
    private final IPropertySourceParser<BigInteger> m_parser = new BigIntegerPropertySourceParser();

    public BigIntegerPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[\\-\\+0-9]*");
    }

    public IPropertySourceParser<BigInteger> getParser() {
        return this.m_parser;
    }

    @Override
    protected String formatDisplayValue(BigInteger value) throws CoreException {
        if (value == null) {
            return "";
        }
        NumberFormat formatter = DecimalFormat.getNumberInstance(Locale.ENGLISH);
        formatter.setGroupingUsed(false);
        return formatter.format(value);
    }

    @Override
    protected BigInteger parseSourceInput(String input) throws CoreException {
        if ("".equals(input)) {
            return (BigInteger)this.getDefaultValue();
        }
        return (BigInteger)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected BigInteger parseDisplayInput(String input) throws CoreException {
        return this.parseSourceInput(input.replace("'", ""));
    }

    @Override
    protected synchronized void storeValue(BigInteger value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

