/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.BooleanPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BooleanPresenter
extends AbstractMethodPresenter {
    private Button m_checkbox;
    private final IPropertySourceParser<Boolean> m_parser = new BooleanPropertySourceParser();

    public BooleanPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootArea = this.getToolkit().createComposite(container);
        this.m_checkbox = this.getToolkit().createButton(rootArea, "", 32);
        this.m_checkbox.setEnabled(false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanPresenter.this.handleCheckboxSelectionChanged();
            }
        };
        this.m_checkbox.addSelectionListener((SelectionListener)listener);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.spacing = 0;
        rootArea.setLayout((Layout)layout);
        return rootArea;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_checkbox.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_checkbox.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        try {
            this.parseMethodBody();
        }
        catch (JavaModelException e1) {
            ScoutSdkUi.logError("could not parse method body", e1);
        }
        this.m_checkbox.setEnabled(true);
    }

    protected void parseMethodBody() throws CoreException {
        String value = PropertyMethodSourceUtility.getMethodReturnValue((IMethod)this.getMethod().peekMethod());
        boolean checked = (Boolean)this.m_parser.parseSourceValue(value, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
        this.m_checkbox.setSelection(checked);
    }

    private synchronized void handleCheckboxSelectionChanged() {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.m_parser);
            updateOp.setValue((Object)this.m_checkbox.getSelection());
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }
}

