/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementLabelProvider;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractTypeProposalPresenter;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class MenuProposalPresenter
extends AbstractTypeProposalPresenter {
    public MenuProposalPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getProposalField().setContentProvider(new P_ContentProvider(labelProvider));
    }

    private final class P_ContentProvider
    extends ContentProposalProvider {
        private final ILabelProvider m_labelProvider;
        private IType[] m_proposals;

        private P_ContentProvider(ILabelProvider labelProvider) {
            this.m_labelProvider = labelProvider;
        }

        @Override
        public synchronized Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
            this.ensureCache();
            searchPattern = !StringUtility.hasText((CharSequence)searchPattern) ? "*" : String.valueOf(IRegEx.STAR_END.matcher(searchPattern).replaceAll("")) + "*";
            char[] pattern = CharOperation.toLowerCase((char[])searchPattern.toCharArray());
            ArrayList<IType> collector = new ArrayList<IType>();
            IType[] iTypeArray = this.m_proposals;
            int n = this.m_proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IType proposal = iTypeArray[n2];
                if (CharOperation.match((char[])pattern, (char[])this.m_labelProvider.getText((Object)proposal).toCharArray(), (boolean)false)) {
                    collector.add(proposal);
                }
                ++n2;
            }
            return collector.toArray(new Object[collector.size()]);
        }

        @Override
        public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.m_proposals = null;
        }

        private void collectMenusRec(List<IType> collector, IType declaringType) {
            for (IType t : ScoutTypeUtility.getMenus((IType)declaringType)) {
                collector.add(t);
                this.collectMenusRec(collector, t);
            }
        }

        private void ensureCache() {
            if (this.m_proposals == null) {
                if (MenuProposalPresenter.this.getMethod() != null) {
                    ArrayList<IType> collector = new ArrayList<IType>();
                    this.collectMenusRec(collector, MenuProposalPresenter.this.getMethod().getType());
                    this.m_proposals = collector.toArray(new IType[collector.size()]);
                } else {
                    this.m_proposals = new IType[0];
                }
            }
        }
    }
}

