/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.menu;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.extensions.IContextMenuContributor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.ContextMenuContributorExtensionPoint;
import org.eclipse.scout.sdk.ui.menu.ScoutMenuContributionItemFactory;
import org.eclipse.ui.services.IServiceLocator;

public class MenuVisibilityTester
extends PropertyTester {
    private static final int MENU_PREPARATION_MAX_DURATION = 15;

    private static IContextMenuContributor getMenuContributor(Class<? extends IScoutHandler> menu, Object o) {
        for (IContextMenuContributor c : ContextMenuContributorExtensionPoint.getContextMenuContributors(o)) {
            Set<Class<? extends IScoutHandler>> supportedMenuActions = c.getSupportedMenuActionsFor(o);
            if (supportedMenuActions == null || !supportedMenuActions.contains(menu)) continue;
            return c;
        }
        return null;
    }

    private static boolean isMenuSupportedForSelection(Class<? extends IScoutHandler> menu, Collection<?> selection) {
        for (Object o : selection) {
            if (MenuVisibilityTester.getMenuContributor(menu, o) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean areArgumentsValid(Object[] args) {
        return args != null && args.length == 3 && args[0] instanceof Class && args[1] instanceof Command && args[2] instanceof IServiceLocator && IScoutHandler.class.isAssignableFrom((Class)args[0]);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        long menuPreparationStartTime;
        StructuredSelection curSelection;
        IScoutHandler currentMenu;
        Command cmd;
        Class currentMenuClass;
        block16: {
            Collection col;
            block15: {
                block14: {
                    block13: {
                        if (!MenuVisibilityTester.areArgumentsValid(args)) {
                            return false;
                        }
                        col = null;
                        if (receiver instanceof Collection) {
                            col = (Collection)receiver;
                        } else if (receiver instanceof IStructuredSelection) {
                            col = ((IStructuredSelection)receiver).toList();
                        }
                        if (col == null) {
                            return false;
                        }
                        if (col.isEmpty()) {
                            return false;
                        }
                        try {
                            currentMenuClass = (Class)args[0];
                            cmd = (Command)args[1];
                            if (MenuVisibilityTester.isMenuSupportedForSelection(currentMenuClass, col)) break block13;
                            return false;
                        }
                        catch (Exception e) {
                            ScoutSdkUi.logError(e);
                            return false;
                        }
                    }
                    currentMenu = ScoutMenuContributionItemFactory.getMenuInstance(currentMenuClass);
                    if (currentMenu != null) break block14;
                    return false;
                }
                cmd.setHandler((IHandler)currentMenu);
                if (currentMenu.isMultiSelectSupported() || col.size() <= 1) break block15;
                return false;
            }
            curSelection = new StructuredSelection(col.toArray(new Object[col.size()]));
            menuPreparationStartTime = System.currentTimeMillis();
            if (currentMenu.isVisible((IStructuredSelection)curSelection)) break block16;
            return false;
        }
        currentMenu.setEnabled(new BooleanHolder(Boolean.valueOf(currentMenu.isActive((IStructuredSelection)curSelection))));
        long duration = System.currentTimeMillis() - menuPreparationStartTime;
        if (duration > 15L) {
            ScoutSdkUi.logWarning("Context menu '" + currentMenuClass.getName() + "' took longer than " + 15 + "ms to calculate its state (" + duration + "ms).");
        }
        IServiceLocator serviceLocator = (IServiceLocator)args[2];
        ScoutMenuContributionItemFactory.activateHandler(serviceLocator, currentMenu);
        ScoutMenuContributionItemFactory.registerKeyStroke(currentMenu.getKeyStroke(), cmd);
        return true;
    }
}

