/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.action.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.ServiceOperationNewAction;
import org.eclipse.scout.sdk.ui.action.delete.ServiceDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.ServiceRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServiceOperationNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.MethodComparators;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public abstract class AbstractServiceNodePage
extends AbstractScoutTypePage {
    private final IType m_interfaceType;
    private P_ServiceMethodsListener m_serviceMethodListener;

    public AbstractServiceNodePage(AbstractPage parent, IType type, IType interfaceType, String readOnlySuffix) {
        super(readOnlySuffix);
        this.setParent(parent);
        this.setType(type);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service.png"));
        this.m_interfaceType = interfaceType;
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceMethodListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeMethodChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
            this.m_serviceMethodListener = null;
        }
        super.unloadPage();
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_interfaceType == null) {
            return;
        }
        if (this.m_serviceMethodListener == null) {
            this.m_serviceMethodListener = new P_ServiceMethodsListener();
            ScoutSdkCore.getJavaResourceChangedEmitter().addMethodChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_serviceMethodListener);
        }
        Set serviceMethods = TypeUtility.getMethods((IType)this.getType(), (IMethodFilter)MethodFilters.getFlagsFilter((int)1), (Comparator)MethodComparators.getNameComparator());
        try {
            TreeMap<String, IMethod> interfaceMethodsMap = new TreeMap<String, IMethod>();
            if (TypeUtility.exists((IJavaElement)this.getInterfaceType())) {
                for (IMethod m : TypeUtility.getMethods((IType)this.getInterfaceType())) {
                    interfaceMethodsMap.put(SignatureUtility.getMethodIdentifier((IMethod)m), m);
                }
            }
            for (IMethod implMethod : serviceMethods) {
                new ServiceOperationNodePage(this, (IMethod)interfaceMethodsMap.get(SignatureUtility.getMethodIdentifier((IMethod)implMethod)), implMethod);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError(e);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(ServiceRenameAction.class, ShowJavaReferencesAction.class, FormDataSqlBindingValidateAction.class, ServiceOperationNewAction.class, ServiceDeleteAction.class);
    }

    public IType getInterfaceType() {
        return this.m_interfaceType;
    }

    private class P_ServiceMethodsListener
    implements IJavaResourceChangedListener {
        private P_ServiceMethodsListener() {
        }

        public void handleEvent(JdtEvent event) {
            AbstractServiceNodePage.this.markStructureDirty();
        }
    }
}

