/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class FormPropertyPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";
    private final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    private final IType permission = TypeUtility.getType((String)"java.security.Permission");

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        linkSection.setExpanded(this.wasSectionExpanded(SECTION_ID_LINKS, true));
        super.createSections();
    }

    @Override
    public FormNodePage getPage() {
        return (FormNodePage)super.getPage();
    }

    protected void fillLinkSection(Composite parent) {
        final LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
        final ProgressIndicator indicator = new ProgressIndicator(presenter.getContainer(), 65538);
        indicator.beginAnimatedTask();
        GridData indicatorData = new GridData(768);
        indicatorData.horizontalSpan = 2;
        indicatorData.heightHint = 5;
        indicator.setLayoutData((Object)indicatorData);
        Job j = new Job("load links..."){

            protected IStatus run(IProgressMonitor monitor) {
                String entityName = null;
                LinksPresenterModel model = new LinksPresenterModel();
                IType form = FormPropertyPart.this.getPage().getType();
                if (TypeUtility.exists((IJavaElement)form)) {
                    model.addGlobalLink(new TypeOpenLink(form));
                    entityName = FormPropertyPart.this.findEntityName(form.getElementName());
                }
                if (!StringUtility.isNullOrEmpty(entityName)) {
                    try {
                        int flags;
                        ITypeHierarchy formSuperTypeHierarchy = ScoutTypeUtility.getSupertypeHierarchy((IType)form);
                        IType formSuperClass = formSuperTypeHierarchy.getSuperclass(form);
                        if (TypeUtility.exists((IJavaElement)formSuperClass) && !Flags.isAbstract((int)(flags = formSuperClass.getFlags())) && !Flags.isInterface((int)flags)) {
                            TypeOpenLink lnk = new TypeOpenLink(formSuperClass);
                            lnk.setName(formSuperClass.getElementName());
                            model.addGlobalLink(lnk);
                        }
                    }
                    catch (JavaModelException e) {
                        ScoutSdkUi.logError(e);
                    }
                    IType formDataType = null;
                    try {
                        formDataType = ScoutTypeUtility.findDtoForForm((IType)form);
                    }
                    catch (JavaModelException e) {
                        ScoutSdkUi.logError(e);
                    }
                    if (TypeUtility.exists((IJavaElement)formDataType)) {
                        model.addGlobalLink(new TypeOpenLink(formDataType));
                    }
                    IScoutBundle client = FormPropertyPart.this.getPage().getScoutBundle();
                    Set shareds = client.getParentBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
                    HashSet<IScoutBundle> serversAndSharedsSet = new HashSet<IScoutBundle>();
                    for (IScoutBundle shared : shareds) {
                        serversAndSharedsSet.add(shared);
                        for (IScoutBundle server : shared.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), false)) {
                            serversAndSharedsSet.add(server);
                        }
                    }
                    String formRegex = "(I)?" + entityName + "(Process)?" + "Service";
                    ITypeFilter formFilter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)formRegex), ScoutTypeFilters.getInScoutBundles(serversAndSharedsSet)});
                    LinkGroup serviceGroup = model.getOrCreateGroup(Texts.get((String)"Service"), 10);
                    for (IType candidate : TypeUtility.getPrimaryTypeHierarchy((IType)FormPropertyPart.this.iService).getAllSubtypes(FormPropertyPart.this.iService, formFilter, TypeComparators.getTypeNameComparator())) {
                        serviceGroup.addLink(new TypeOpenLink(candidate));
                    }
                    String permissionRegex = "(Create|Read|Update)" + entityName + "Permission";
                    ITypeFilter filter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getRegexSimpleNameFilter((String)permissionRegex), TypeFilters.getClassFilter(), ScoutTypeFilters.getInScoutBundles((Collection)shareds)});
                    LinkGroup permissionGroup = model.getOrCreateGroup(Texts.get((String)"PermissionTablePage"), 20);
                    for (IType candidate : TypeUtility.getPrimaryTypeHierarchy((IType)FormPropertyPart.this.permission).getAllSubtypes(FormPropertyPart.this.permission, filter, TypeComparators.getTypeNameComparator())) {
                        permissionGroup.addLink(new TypeOpenLink(candidate));
                    }
                }
                if (presenter != null && !presenter.isDisposed()) {
                    final LinksPresenterModel finalModel = model;
                    presenter.getContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (presenter != null && !presenter.isDisposed()) {
                                indicator.dispose();
                                presenter.setLinksProperty(finalModel);
                                FormPropertyPart.this.getForm().layout(true, true);
                                FormPropertyPart.this.getForm().updateToolBar();
                                FormPropertyPart.this.getForm().reflow(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    private String findEntityName(String serviceName) {
        if (StringUtility.isNullOrEmpty((CharSequence)serviceName)) {
            return serviceName;
        }
        if (serviceName.endsWith("Form")) {
            return serviceName.replaceAll("^(.*)Form$", "$1");
        }
        return serviceName;
    }
}

