/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.CompilationUnitSaveOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.DocumentationPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecMethodPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecResetSearchFilterMethodPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.PageFilterPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.BigDecimalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.BigIntegerPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.BooleanPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.BorderDecorationPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ButtonDisplayStylePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ButtonSystemTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.CodeTypeProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ColorPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.ComposerAttributeTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.DoublePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.DragAndDropTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FontPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FormDisplayHintPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.FormViewIdPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.GroupBoxBodyGridPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.HorizontalAlignmentPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.IconPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.IntegerPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LabelHorizontalAlignmentPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LabelPositionPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LongPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LookupCallProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.LookupServiceProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MasterFieldPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MenuProposalPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MenuTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.MultiLineStringPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.NlsTextPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.OutlineRootPagePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.OutlinesPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.PrimitiveTypePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.RoundingModePresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.SearchFormPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.StringPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single.VerticalAglinmentPresenter;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.ConfigurationMethodSection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.PropertyViewConfig;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyType;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class JdtTypePropertyPart
extends AbstractSinglePageSectionBasedViewPart {
    protected static final String SECTION_ID_FILTER = "section.filter";
    protected static final String SECTION_ID_DOCUMENTATION = "section.documentation";
    protected static final String SECTION_ID_PROPS_IMPORTANT = "section.properties.important";
    protected static final String SECTION_ID_PROPS_ADVANCED = "section.properties.advanced";
    protected static final String SECTION_ID_OPS_IMPORTANT = "section.operations.important";
    protected static final String SECTION_ID_OPS_ADVANCED = "section.operations.advanced";
    private final Map<String, AbstractMethodPresenter> m_methodPresenters;
    private final Map<String, ConfigurationMethod> m_methodsToUpdate = new HashMap<String, ConfigurationMethod>();
    private P_UpdateMethodsJob m_updateJob;
    private final Object m_methodUpdateLock;
    private final P_MarkDirtyJob m_markDirtyJob;
    private final Object m_markDirtyLock;
    private IJavaResourceChangedListener m_methodChangedListener;
    private ConfigPropertyType m_configPropertyType;
    private Button m_saveButton;
    private IStatus m_icuNotSyncStatus;

    public JdtTypePropertyPart() {
        this.m_methodPresenters = new HashMap<String, AbstractMethodPresenter>();
        this.m_methodUpdateLock = new Object();
        this.m_markDirtyJob = new P_MarkDirtyJob();
        this.m_markDirtyLock = new Object();
    }

    @Override
    protected String getPartKey() {
        if (this.getPage() == null || !TypeUtility.exists((IJavaElement)this.getPage().getType())) {
            return null;
        }
        return this.getPage().getType().getFullyQualifiedName();
    }

    @Override
    public AbstractScoutTypePage getPage() {
        return (AbstractScoutTypePage)super.getPage();
    }

    ISection addSection(String sectionId, String title) {
        return super.createSection(sectionId, title);
    }

    private boolean isDirty() {
        return this.m_markDirtyJob.isDirty();
    }

    @Override
    public void setPage(IPage page) {
        super.setPage(page);
        this.m_icuNotSyncStatus = new Status(1, "org.eclipse.scout.sdk.ui", Texts.get((String)"SaveTheFile", (String[])new String[]{this.getPage().getType().getPath().toOSString()}));
    }

    private int getTitleHyperlinkWidth() {
        int TEXT_SPACE_MARGIN_RIGHT = 110;
        Rectangle b = this.getForm().getParent().getBounds();
        int w = Math.max(b.width - 110, 110);
        return w;
    }

    @Override
    protected Control createHead(final Composite parent) {
        Composite headArea = this.getFormToolkit().createComposite(parent);
        final Font font = ScoutSdkUi.getFont("fontSystemTitle");
        String text = UiUtility.getTextForBounds(this.getPage().getName(), font, (Drawable)parent, this.getTitleHyperlinkWidth());
        final Hyperlink title = this.getFormToolkit().createHyperlink(headArea, text, 64);
        title.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                try {
                    JdtTypePropertyPart.this.getForm().setRedraw(false);
                    String txt = UiUtility.getTextForBounds(JdtTypePropertyPart.this.getPage().getName(), font, (Drawable)parent, JdtTypePropertyPart.this.getTitleHyperlinkWidth());
                    title.setText(txt);
                    JdtTypePropertyPart.this.getForm().reflow(true);
                    JdtTypePropertyPart.this.getForm().getParent().layout(true, true);
                }
                finally {
                    JdtTypePropertyPart.this.getForm().setRedraw(true);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        title.setToolTipText(this.getPage().getName());
        title.setFont(font);
        title.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UiUtility.showJavaElementInEditor((IJavaElement)JdtTypePropertyPart.this.getPage().getType(), true);
            }
        });
        this.m_saveButton = this.getFormToolkit().createButton(headArea, Texts.get((String)"SaveFile"), 8);
        this.m_saveButton.setEnabled(false);
        this.m_saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICompilationUnit icu = JdtTypePropertyPart.this.getPage().getType().getCompilationUnit();
                if (icu.isWorkingCopy()) {
                    CompilationUnitSaveOperation op = new CompilationUnitSaveOperation(icu);
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        });
        headArea.setLayout((Layout)new GridLayout(2, false));
        GridData titleData = new GridData(800);
        title.setLayoutData((Object)titleData);
        this.m_saveButton.setLayoutData((Object)new GridData(896));
        return headArea;
    }

    protected void createDocumentationSectionContent(ISection docSection) {
        DocumentationPresenter docPresenter = new DocumentationPresenter(this.getFormToolkit(), docSection.getSectionClient(), this.getPage());
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        docPresenter.getContainer().setLayoutData((Object)layoutData);
    }

    @Override
    protected void createSections() {
        IType iTypeWithClassId;
        INlsProject docsNlsProject;
        IScoutBundle bundle;
        if (this.m_updateJob == null) {
            this.m_updateJob = new P_UpdateMethodsJob(this.getForm().getDisplay());
        }
        if (this.getPage().isFolder()) {
            ISection filterSection = this.createSection(SECTION_ID_FILTER, Texts.get((String)"Filter"));
            PageFilterPresenter filterPresenter = new PageFilterPresenter(this.getFormToolkit(), filterSection.getSectionClient(), this.getPage());
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            filterPresenter.getContainer().setLayoutData((Object)layoutData);
            filterSection.setExpanded(this.wasSectionExpanded(SECTION_ID_FILTER, false));
        }
        if ((bundle = this.getPage().getScoutBundle()) != null && (docsNlsProject = bundle.getDocsNlsProject()) != null && TypeUtility.exists((IJavaElement)(iTypeWithClassId = TypeUtility.getType((String)"org.eclipse.scout.commons.ITypeWithClassId"))) && TypeUtility.exists((IJavaElement)this.getPage().getType()) && TypeUtility.getSupertypeHierarchy((IType)this.getPage().getType()).contains(iTypeWithClassId)) {
            final ISection docSection = this.createSection(SECTION_ID_DOCUMENTATION, Texts.get((String)"Documentation"));
            docSection.setExpanded(this.wasSectionExpanded(SECTION_ID_DOCUMENTATION, false));
            if (docSection.isExpanded()) {
                this.createDocumentationSectionContent(docSection);
            } else {
                docSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanging(ExpansionEvent e) {
                        if (e.getState()) {
                            JdtTypePropertyPart.this.createDocumentationSectionContent(docSection);
                            docSection.removeExpansionListener((IExpansionListener)this);
                        }
                    }
                });
            }
        }
        try {
            boolean noImpProps;
            this.m_configPropertyType = new ConfigPropertyType(this.getPage().getType());
            boolean bl = noImpProps = !this.createImportantProperties();
            if (noImpProps) {
                this.createAdvancedProperties(false);
                boolean created = this.createImportantOperations();
                this.createAdvancedOperations(created);
            } else {
                boolean noImpOps;
                boolean bl2 = noImpOps = !this.createImportantOperations();
                if (noImpOps) {
                    this.createAdvancedOperations(false);
                    this.createAdvancedProperties(true);
                } else {
                    this.createAdvancedProperties(true);
                    this.createAdvancedOperations(true);
                }
            }
            if (this.m_methodChangedListener == null) {
                this.m_methodChangedListener = new P_MethodChangedListener();
                ScoutSdkCore.getJavaResourceChangedEmitter().addJavaResourceChangedListener(this.m_methodChangedListener);
            }
            if (this.getPage().getType().getCompilationUnit() == null) {
                this.setCompilationUnitDirty(false);
            } else {
                this.setCompilationUnitDirty(this.getPage().getType().getCompilationUnit().isWorkingCopy() && this.getPage().getType().getCompilationUnit().getBuffer().hasUnsavedChanges());
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning("could not create config property page for '" + this.getPage().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    private boolean createImportantProperties() {
        ConfigurationMethodSection impConfigPropsSection = new ConfigurationMethodSection(this.m_configPropertyType, 1, PropertyViewConfig.ConfigTypes.NORMAL);
        ISection impPropsSection = impConfigPropsSection.createContent(this, SECTION_ID_PROPS_IMPORTANT, Texts.get((String)"Properties"), this.wasSectionExpanded(SECTION_ID_PROPS_IMPORTANT, true));
        return impPropsSection != null;
    }

    private boolean createImportantOperations() {
        ConfigurationMethodSection importantExecSection = new ConfigurationMethodSection(this.m_configPropertyType, 2, PropertyViewConfig.ConfigTypes.NORMAL);
        ISection impOpsSection = importantExecSection.createContent(this, SECTION_ID_OPS_IMPORTANT, Texts.get((String)"Operations"), this.wasSectionExpanded(SECTION_ID_OPS_IMPORTANT, true));
        return impOpsSection != null;
    }

    private boolean createAdvancedProperties(boolean importantCreated) {
        ConfigurationMethodSection advancedConfigPropsSection = new ConfigurationMethodSection(this.m_configPropertyType, 1, PropertyViewConfig.ConfigTypes.ADVANCED);
        ISection advPropsSection = advancedConfigPropsSection.createContent(this, SECTION_ID_PROPS_ADVANCED, Texts.get((String)(importantCreated ? "AdvancedProperties" : "Properties")), this.wasSectionExpanded(SECTION_ID_PROPS_ADVANCED, !importantCreated));
        return advPropsSection != null;
    }

    private boolean createAdvancedOperations(boolean importantCreated) {
        ConfigurationMethodSection advancedExecSection = new ConfigurationMethodSection(this.m_configPropertyType, 2, PropertyViewConfig.ConfigTypes.ADVANCED);
        ISection advOpsSection = advancedExecSection.createContent(this, SECTION_ID_OPS_ADVANCED, Texts.get((String)(importantCreated ? "AdvancedOperations" : "Operations")), this.wasSectionExpanded(SECTION_ID_OPS_ADVANCED, !importantCreated));
        return advOpsSection != null;
    }

    @Override
    protected void cleanup() {
        if (this.m_methodChangedListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeJavaResourceChangedListener(this.m_methodChangedListener);
            this.m_methodChangedListener = null;
        }
        super.cleanup();
    }

    AbstractMethodPresenter createConfigMethodPresenter(Composite parent, ConfigurationMethod method) {
        AbstractMethodPresenter presenter = null;
        String propertyType = StringUtility.uppercase((String)method.getConfigAnnotationType());
        if ("BOOLEAN".equals(propertyType)) {
            presenter = new BooleanPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("DOUBLE".equals(propertyType)) {
            presenter = new DoublePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("BIG_DECIMAL".equals(propertyType)) {
            presenter = new BigDecimalPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("DRAG_AND_DROP_TYPE".equals(propertyType)) {
            presenter = new DragAndDropTypePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("INTEGER".equals(propertyType)) {
            presenter = new IntegerPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("LONG".equals(propertyType)) {
            presenter = new LongPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("BIG_INTEGER".equals(propertyType)) {
            presenter = new BigIntegerPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("STRING".equals(propertyType)) {
            presenter = new StringPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("FONT".equals(propertyType)) {
            presenter = new FontPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("COLOR".equals(propertyType)) {
            presenter = new ColorPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("BUTTON_DISPLAY_STYLE".equals(propertyType)) {
            presenter = new ButtonDisplayStylePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("BUTTON_SYSTEM_TYPE".equals(propertyType)) {
            presenter = new ButtonSystemTypePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("CODE_TYPE".equals(propertyType)) {
            presenter = new CodeTypeProposalPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("COMPOSER_ATTRIBUTE_TYPE".equals(propertyType)) {
            presenter = new ComposerAttributeTypePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("FORM_DISPLAY_HINT".equals(propertyType)) {
            presenter = new FormDisplayHintPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("FORM_VIEW_ID".equals(propertyType)) {
            presenter = new FormViewIdPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("HORIZONTAL_ALIGNMENT".equals(propertyType)) {
            presenter = new HorizontalAlignmentPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("ICON_ID".equals(propertyType)) {
            presenter = new IconPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("LOOKUP_CALL".equals(propertyType)) {
            presenter = new LookupCallProposalPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("LOOKUP_SERVICE".equals(propertyType)) {
            presenter = new LookupServiceProposalPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("MASTER_FIELD".equals(propertyType)) {
            presenter = new MasterFieldPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("OUTLINE_ROOT_PAGE".equals(propertyType)) {
            presenter = new OutlineRootPagePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("OUTLINES".equals(propertyType)) {
            presenter = new OutlinesPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("SEARCH_FORM".equals(propertyType)) {
            presenter = new SearchFormPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("SQL".equals(propertyType)) {
            presenter = new MultiLineStringPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("TEXT".equals(propertyType)) {
            presenter = new NlsTextPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("VERTICAL_ALIGNMENT".equals(propertyType)) {
            presenter = new VerticalAglinmentPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("MENU_CLASS".equals(propertyType)) {
            presenter = new MenuProposalPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("PRIMITIVE_TYPE".equals(propertyType)) {
            presenter = new PrimitiveTypePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("LABEL_POSITION".equals(propertyType)) {
            presenter = new LabelPositionPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("LABEL_HORIZONTAL_ALIGNMENT".equals(propertyType)) {
            presenter = new LabelHorizontalAlignmentPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("BORDER_DECORATION".equals(propertyType)) {
            presenter = new BorderDecorationPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("ROUNDING_MODE".equals(propertyType)) {
            presenter = new RoundingModePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("GROUP_BOX_BODY_GRID".equals(propertyType)) {
            presenter = new GroupBoxBodyGridPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else if ("MENU_TYPE".equals(propertyType)) {
            presenter = new MenuTypePresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else {
            presenter = new ExecMethodPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        }
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
        presenter.setEnabled(this.isPresenterEnabled(method));
        this.m_methodPresenters.put(method.getMethodName(), presenter);
        return presenter;
    }

    private static boolean isFinal(IMethod m) {
        if (m == null) {
            return false;
        }
        try {
            return (m.getFlags() & 0x10) != 0;
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("Unable to retrieve flags for method '" + m.getElementName() + "'.", e);
            return false;
        }
    }

    private boolean isPresenterEnabled(ConfigurationMethod m) {
        return this.isPresenterEnabled(m, this.isDirty());
    }

    private boolean isPresenterEnabled(ConfigurationMethod m, boolean compilationUnitDirty) {
        return !JdtTypePropertyPart.isFinal(m.getDefaultMethod()) && !compilationUnitDirty && !this.getPage().getType().isReadOnly();
    }

    AbstractMethodPresenter createOperationPresenter(Composite parent, ConfigurationMethod method) {
        ExecMethodPresenter presenter = null;
        if ("execResetSearchFilter".equals(method.getMethodName())) {
            presenter = new ExecResetSearchFilterMethodPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        } else {
            presenter = new ExecMethodPresenter(this.getFormToolkit(), parent);
            presenter.setMethod(method);
        }
        if (presenter != null) {
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            presenter.getContainer().setLayoutData((Object)layoutData);
            ((AbstractMethodPresenter)presenter).setEnabled(this.isPresenterEnabled(method));
            this.m_methodPresenters.put(method.getMethodName(), presenter);
        }
        return presenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMethodChanged(IMethod method) {
        block6: {
            if (this.m_configPropertyType.isRelevantType(method.getDeclaringType())) {
                try {
                    ConfigurationMethod updatedMethod = this.m_configPropertyType.updateIfChanged(method);
                    if (updatedMethod == null) break block6;
                    Object object = this.m_methodUpdateLock;
                    synchronized (object) {
                        this.m_methodsToUpdate.put(updatedMethod.getMethodName(), updatedMethod);
                        this.m_updateJob.cancel();
                        this.m_updateJob.schedule(150L);
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("Unable to update method '" + method.getElementName() + "'.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompilationUnitDirty(final boolean dirty) {
        Object object = this.m_markDirtyLock;
        synchronized (object) {
            ScrolledForm form = this.getForm();
            if (form != null && !form.isDisposed()) {
                form.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (JdtTypePropertyPart.this.getForm() != null && !JdtTypePropertyPart.this.getForm().isDisposed()) {
                            JdtTypePropertyPart.this.m_saveButton.setEnabled(dirty);
                            for (AbstractMethodPresenter p : JdtTypePropertyPart.this.m_methodPresenters.values()) {
                                p.setEnabled(JdtTypePropertyPart.this.isPresenterEnabled(p.getMethod(), dirty));
                            }
                            if (dirty) {
                                JdtTypePropertyPart.this.addStatus(JdtTypePropertyPart.this.m_icuNotSyncStatus);
                            } else {
                                JdtTypePropertyPart.this.removeStatus(JdtTypePropertyPart.this.m_icuNotSyncStatus);
                            }
                        }
                    }
                });
            }
        }
    }

    private class P_MarkDirtyJob
    extends Job {
        private boolean m_dirty;

        public P_MarkDirtyJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            JdtTypePropertyPart.this.setCompilationUnitDirty(this.m_dirty);
            return Status.OK_STATUS;
        }

        public void setDirty(boolean dirty) {
            this.m_dirty = dirty;
        }

        public boolean isDirty() {
            return this.m_dirty;
        }
    }

    private class P_MethodChangedListener
    implements IJavaResourceChangedListener {
        private P_MethodChangedListener() {
        }

        public void handleEvent(JdtEvent event) {
            switch (event.getEventType()) {
                case 1: 
                case 2: 
                case 4: {
                    if (event.getElement().getElementType() != 9) break;
                    JdtTypePropertyPart.this.handleMethodChanged((IMethod)event.getElement());
                    break;
                }
                case 10: {
                    if (event.getElementType() != 5 || !event.getElement().equals(JdtTypePropertyPart.this.getPage().getType().getCompilationUnit())) break;
                    JdtTypePropertyPart.this.m_markDirtyJob.cancel();
                    JdtTypePropertyPart.this.m_markDirtyJob.setDirty(true);
                    JdtTypePropertyPart.this.m_markDirtyJob.schedule(150L);
                    break;
                }
                case 11: {
                    if (event.getElementType() != 5 || !event.getElement().equals(JdtTypePropertyPart.this.getPage().getType().getCompilationUnit())) break;
                    JdtTypePropertyPart.this.m_markDirtyJob.cancel();
                    JdtTypePropertyPart.this.m_markDirtyJob.setDirty(false);
                    JdtTypePropertyPart.this.m_markDirtyJob.schedule(150L);
                }
            }
        }
    }

    private class P_UpdateMethodsJob
    extends Job {
        private final Display m_display;

        public P_UpdateMethodsJob(Display display) {
            super("");
            this.m_display = display;
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ArrayList methods = null;
            Object object = JdtTypePropertyPart.this.m_methodUpdateLock;
            synchronized (object) {
                methods = CollectionUtility.arrayList(JdtTypePropertyPart.this.m_methodsToUpdate.values());
                JdtTypePropertyPart.this.m_methodsToUpdate.clear();
            }
            for (ConfigurationMethod cm : methods) {
                AbstractMethodPresenter presenter = (AbstractMethodPresenter)JdtTypePropertyPart.this.m_methodPresenters.get(cm.getMethodName());
                if (presenter == null) continue;
                RunnableWithData runnable = new RunnableWithData(){

                    public void run() {
                        ((AbstractMethodPresenter)this.getData("presenter")).setMethod((ConfigurationMethod)this.getData("configMethod"));
                    }
                };
                runnable.setData("presenter", (Object)presenter);
                runnable.setData("configMethod", (Object)cm);
                if (this.m_display == null || this.m_display.isDisposed()) continue;
                this.m_display.syncExec((Runnable)runnable);
            }
            return Status.OK_STATUS;
        }
    }
}

