/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractProposalPresenter<T>
extends AbstractMethodPresenter {
    private ProposalTextField m_proposalField;
    private T m_currentSourceValue;
    private T m_defaultValue;
    private boolean m_defaultValueInitialized = false;
    private final OptimisticLock m_storeValueLock = new OptimisticLock();

    public AbstractProposalPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_proposalField = this.getToolkit().createProposalField(container, "", 1024);
        this.createProposalFieldProviders(this.m_proposalField);
        this.m_proposalField.setEnabled(false);
        P_ProposalFieldListener listener = new P_ProposalFieldListener();
        this.m_proposalField.addProposalAdapterListener(listener);
        return this.m_proposalField;
    }

    protected abstract void createProposalFieldProviders(ProposalTextField var1);

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        this.setCurrentSourceValue(this.parseInput(this.getMethod().computeValue()));
        try {
            this.m_storeValueLock.acquire();
            if (this.getCurrentSourceValue() != null) {
                this.m_proposalField.acceptProposal(this.getCurrentSourceValue());
            } else {
                this.m_proposalField.setText("");
            }
            this.m_proposalField.setEnabled(true);
        }
        finally {
            this.m_storeValueLock.release();
        }
    }

    protected abstract T parseInput(String var1) throws CoreException;

    protected abstract void storeValue(T var1) throws CoreException;

    public T getCurrentSourceValue() {
        return this.m_currentSourceValue;
    }

    public void setCurrentSourceValue(T value) {
        this.m_currentSourceValue = value;
    }

    public T getDefaultValue() throws CoreException {
        if (!this.m_defaultValueInitialized) {
            this.m_defaultValue = this.parseInput(this.getMethod().computeDefaultValue());
            this.m_defaultValueInitialized = true;
        }
        return this.m_defaultValue;
    }

    public ProposalTextField getProposalField() {
        return this.m_proposalField;
    }

    private class P_ProposalFieldListener
    implements IProposalAdapterListener {
        private P_ProposalFieldListener() {
        }

        @Override
        public void proposalAccepted(ContentProposalEvent event) {
            AbstractProposalPresenter.this.setCurrentSourceValue(event.proposal);
            try {
                if (AbstractProposalPresenter.this.m_storeValueLock.acquire()) {
                    try {
                        AbstractProposalPresenter.this.storeValue(AbstractProposalPresenter.this.getCurrentSourceValue());
                    }
                    catch (CoreException e) {
                        ScoutSdkUi.logError("Error changing the property value.", e);
                    }
                }
            }
            finally {
                AbstractProposalPresenter.this.m_storeValueLock.release();
            }
        }
    }
}

