/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.tooltip.CustomTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.SdkProperties;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class MethodErrorPresenterContent
extends Composite {
    private final FormToolkit m_toolkit;
    private Hyperlink m_labelLink;
    private Label m_label;
    private Label m_statusLabel;
    private Label m_statusIcon;
    private ImageHyperlink m_deleteButton;
    private ConfigurationMethod m_configurationMethod;
    private CustomTooltip m_customTooltip;
    private Composite m_linkComposite;

    public MethodErrorPresenterContent(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.m_toolkit = toolkit;
        this.createContent(this);
    }

    private void createContent(Composite parent) {
        this.m_linkComposite = this.getToolkit().createComposite(parent);
        GridData linkCompData = new GridData();
        linkCompData.widthHint = 180;
        this.m_linkComposite.setLayoutData((Object)linkCompData);
        this.m_linkComposite.setLayout((Layout)new GridLayout(1, true));
        this.createLabelArea(this.m_linkComposite);
        this.createBodyArea(parent);
        GridLayout bodyLayout = new GridLayout(3, false);
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        bodyLayout.verticalSpacing = 0;
        parent.setLayout((Layout)bodyLayout);
        parent.setLayoutData((Object)new GridData(1808));
    }

    private void createBodyArea(Composite rootArea) {
        Composite area = this.getToolkit().createComposite(rootArea);
        this.m_statusIcon = this.getToolkit().createLabel(area, "");
        this.m_statusLabel = this.getToolkit().createLabel(area, "");
        this.m_deleteButton = this.getToolkit().createImageHyperlink(rootArea, 8);
        this.m_deleteButton.setImage(ScoutSdkUi.getImage("remove.png"));
        this.m_deleteButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                new OperationJob(new IOperation[]{new ScoutMethodDeleteOperation(MethodErrorPresenterContent.this.getMethod().peekMethod())}).schedule();
            }
        });
        GridLayout glayout = new GridLayout(3, false);
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        glayout.horizontalSpacing = 3;
        area.setLayout((Layout)glayout);
        area.setLayoutData((Object)new GridData(768));
        this.m_statusIcon.setLayoutData((Object)new GridData(1));
        this.m_statusLabel.setLayoutData((Object)new GridData(768));
        this.m_deleteButton.setLayoutData((Object)new GridData(-1, 22));
        this.m_deleteButton.setEnabled(false);
    }

    private void createLabelArea(Composite parent) {
        if (this.m_labelLink != null) {
            this.m_labelLink.dispose();
        }
        if (this.m_label != null) {
            this.m_label.dispose();
        }
        GridData gd = new GridData(131072, 128, true, false);
        if (this.getMethod() != null && this.getMethod().isImplemented()) {
            this.m_labelLink = this.getToolkit().createHyperlink(parent, "", 0);
            this.m_labelLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    MethodErrorPresenterContent.this.showMethodInEditor(MethodErrorPresenterContent.this.getMethod().peekMethod());
                }
            });
            this.m_labelLink.setFont(this.getFont("org.eclipse.jface.dialogfont", true));
            this.m_labelLink.setLayoutData((Object)gd);
            this.m_customTooltip = new CustomTooltip((Control)this.m_labelLink, true);
        } else {
            this.m_label = this.getToolkit().createLabel(parent, "");
            this.m_label.setForeground(new Color((Device)parent.getDisplay(), 0, 0, 128));
            this.m_label.setLayoutData((Object)gd);
            this.m_customTooltip = new CustomTooltip((Control)this.m_label, true);
        }
    }

    public ConfigurationMethod getMethod() {
        return this.m_configurationMethod;
    }

    public void setMethod(ConfigurationMethod method) {
        this.m_configurationMethod = method;
        try {
            this.setRedraw(false);
            this.createLabelArea(this.m_linkComposite);
            if (this.m_configurationMethod != null && this.m_configurationMethod.isImplemented()) {
                this.m_labelLink.setText(SdkProperties.getMethodPresenterName((IMethod)method.peekMethod()));
            } else {
                this.m_label.setText(SdkProperties.getMethodPresenterName((IMethod)this.getMethod().peekMethod()));
            }
            try {
                this.m_customTooltip.setText(this.wellFormMethod());
            }
            catch (Exception e1) {
                ScoutSdkUi.logWarning("could not create tooltip for '" + method.getMethodName() + "'", e1);
            }
            this.m_deleteButton.setEnabled(method.isImplemented());
            this.m_deleteButton.setToolTipText(Texts.get((String)"RemoveXinY", (String[])new String[]{this.getMethod().getMethodName(), this.getMethod().getType().getElementName()}));
        }
        finally {
            this.setRedraw(true);
            this.layout(true, true);
        }
    }

    public void setStatus(IStatus status) {
        Image image = null;
        String message = "";
        if (status != null) {
            switch (status.getSeverity()) {
                case 4: {
                    image = ScoutSdkUi.getImage("error.gif");
                    break;
                }
                case 2: {
                    image = ScoutSdkUi.getImage("warning.gif");
                    break;
                }
                case 1: {
                    image = ScoutSdkUi.getImage("info.gif");
                }
            }
            message = status.getMessage();
        }
        this.m_statusIcon.setImage(image);
        this.m_statusLabel.setText(message);
    }

    protected FormToolkit getToolkit() {
        return this.m_toolkit;
    }

    protected void showMethodInEditor(IMethod method) {
        try {
            ITextEditor textEditor;
            IRegion reg;
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)method);
            JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)method);
            if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning(e);
        }
    }

    private String wellFormMethod() throws JavaModelException {
        String methodBody = this.getMethod().peekMethod().getSource();
        if (methodBody == null) {
            return null;
        }
        String newBody = MethodErrorPresenterContent.removeLeadingCommentAndAnnotationLines(methodBody);
        String newLine = ResourceUtility.getLineSeparator((IOpenable)this.getMethod().getType().getOpenable());
        newBody = MethodErrorPresenterContent.removeLineLeadingTab(ScoutUtility.getIndent((IType)this.getMethod().getType()).length() + 1, newBody, newLine);
        newBody = newBody.replaceAll("\t", "  ");
        return newBody;
    }

    private static String removeLeadingCommentAndAnnotationLines(String methodBody) {
        Matcher matcherMethodDefinition = IRegEx.METHOD_DEFINITION.matcher(methodBody);
        if (matcherMethodDefinition.find()) {
            methodBody = methodBody.substring(matcherMethodDefinition.start());
        }
        return methodBody;
    }

    private static String removeLineLeadingTab(int i, String methodBlock, String newLine) {
        StringBuilder newBody;
        block18: {
            Pattern p = Pattern.compile("^[\\t]{" + i + "}");
            BufferedReader reader = null;
            newBody = new StringBuilder();
            try {
                try {
                    reader = new BufferedReader(new StringReader(methodBlock));
                    String line = reader.readLine();
                    boolean addNewLine = false;
                    while (line != null) {
                        if (addNewLine) {
                            newBody.append(newLine);
                        } else {
                            addNewLine = true;
                        }
                        Matcher matcher = p.matcher(line);
                        if (matcher.find()) {
                            line = line.substring(matcher.end());
                        }
                        newBody.append(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    ScoutSdkUi.logError("Unable to remove line leading tabs.", e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return newBody.toString();
    }

    protected Font getFont(String symbolicName, boolean bold) {
        if (bold) {
            return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(symbolicName);
        }
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(symbolicName);
    }
}

