/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.form.FormStackNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizard;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FormNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_CREATE_FORM_ID = "createFormId";
    public static final String PROP_FORM_ID_NAME = "formIdName";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private Button m_createFormIdField;
    private StyledTextField m_formIdField;
    private EntityTextField m_entityField;
    private IType m_abstractForm;
    private final IScoutBundle m_clientBundle;

    public FormNewWizardPage(IScoutBundle clientBundle) {
        super(FormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        if (clientBundle != null) {
            this.m_abstractForm = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.form.IForm", (IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)this.m_clientBundle));
            this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.form"));
        }
        this.setTitle(Texts.get((String)"CreateANewForm"));
        this.setDescription(Texts.get((String)"CreateANewForm"));
        this.setSuperTypeInternal(this.m_abstractForm);
        this.setCreateFormId(false);
    }

    @Override
    protected void createContent(Composite p) {
        Group group = new Group(p, 16);
        group.setText(Texts.get((String)"Form"));
        boolean isEnabled = this.getClientBundle() != null;
        int labelColWidthPercent = 20;
        INlsProject nls = null;
        if (this.getClientBundle() != null) {
            nls = this.getClientBundle().getNlsProject();
        }
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)group, nls, Texts.get((String)"PropTitle"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    FormNewWizardPage.this.setStateChanging(true);
                    String oldKey = "";
                    if (FormNewWizardPage.this.getNlsName() != null) {
                        oldKey = FormNewWizardPage.this.getNlsName().getKey();
                    }
                    INlsEntry newName = (INlsEntry)event.proposal;
                    FormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null) {
                        if (StringUtility.isNullOrEmpty((CharSequence)FormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldKey.equals(FormNewWizardPage.this.m_typeNameField.getModifiableText())) {
                            FormNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)newName.getKey(), (boolean)false));
                        }
                        if (StringUtility.isNullOrEmpty((CharSequence)FormNewWizardPage.this.m_formIdField.getModifiableText()) || oldKey.equals(FormNewWizardPage.this.m_formIdField.getModifiableText())) {
                            FormNewWizardPage.this.m_formIdField.setText(NamingUtility.toJavaCamelCase((String)newName.getKey()));
                        }
                    }
                }
                finally {
                    FormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_nlsNameField.setEnabled(isEnabled);
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("Form");
        this.m_typeNameField.setText(this.getTypeName());
        this.setTypeNameInternal(this.m_typeNameField.getText());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setTypeNameInternal(FormNewWizardPage.this.m_typeNameField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField.setEnabled(isEnabled);
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iForm, ScoutUtility.getJavaProject((IScoutBundle)this.getClientBundle()), this.m_abstractForm), labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                FormNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField.setEnabled(isEnabled);
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField((Composite)group, Texts.get((String)"EntityTextField"), this.getClientBundle(), labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage(null));
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FormNewWizardPage.this.setTargetPackageInternal(FormNewWizardPage.this.m_entityField.getText());
                    FormNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
            this.m_entityField.setEnabled(isEnabled);
        }
        Control formIdGroup = this.createIdGroup(p, labelColWidthPercent);
        this.m_nlsNameField.setFocus();
        p.setLayout((Layout)new GridLayout(1, true));
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        formIdGroup.setLayoutData((Object)new GridData(768));
        group.setLayoutData((Object)new GridData(768));
    }

    protected Control createIdGroup(Composite parent, int labelColWidthPercent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"FormId"));
        this.m_createFormIdField = new Button((Composite)group, 32);
        this.m_createFormIdField.setText(Texts.get((String)"CreateFormId"));
        this.m_createFormIdField.setSelection(this.isCreateFormId());
        this.m_createFormIdField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormNewWizardPage.this.setCreateFormIdInternal(FormNewWizardPage.this.m_createFormIdField.getSelection());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_createFormIdField.setEnabled(this.getClientBundle() != null);
        this.m_formIdField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"PropertyNameId"), labelColWidthPercent);
        this.m_formIdField.setReadOnlySuffix("Nr");
        this.m_formIdField.setText(this.getFormId());
        this.setFormIdInternal(this.m_formIdField.getText());
        this.m_formIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormNewWizardPage.this.setFormIdInternal(FormNewWizardPage.this.m_formIdField.getText());
                FormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_formIdField.setEnabled(this.getClientBundle() != null);
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_createFormIdField.setLayoutData((Object)new GridData(768));
        this.m_formIdField.setLayoutData(new GridData(768));
        return group;
    }

    void fillOperation(FormStackNewOperation operation) {
        IType superTypeProp;
        if (this.isCreateFormId() && StringUtility.hasText((CharSequence)this.getFormId())) {
            operation.setFormIdSignature(SignatureCache.createTypeSignature((String)Long.class.getName()));
            operation.setFormIdName(this.getFormId());
        }
        if (this.getNlsName() != null) {
            operation.setNlsEntry(this.getNlsName());
        }
        if ((superTypeProp = this.getSuperType()) != null) {
            operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
    }

    public FormNewWizard getWizard() {
        return (FormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusWorkspace());
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusSuperType());
        multiStatus.add(this.getStatusPropertyId());
        multiStatus.add(this.getStatusTargetPackge());
    }

    protected IStatus getStatusWorkspace() {
        if (this.getClientBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoNewXWithoutScoutBundle", (String[])new String[]{Texts.get((String)"Form")}));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetPackge() {
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            return ScoutUtility.validatePackageName((String)this.getTargetPackage(null));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusPropertyId() {
        if (this.isCreateFormId() && (StringUtility.isNullOrEmpty((CharSequence)this.getFormId()) || this.getFormId().equals("Nr"))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"IdNameMissing"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Form");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getClientBundle(), (String)this.getTargetPackage("client.form"), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public boolean isCreateFormId() {
        return this.getPropertyBool(PROP_CREATE_FORM_ID);
    }

    public void setCreateFormId(boolean createFormId) {
        try {
            this.setStateChanging(true);
            this.setCreateFormIdInternal(createFormId);
            if (this.isControlCreated()) {
                this.m_createFormIdField.setSelection(createFormId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setCreateFormIdInternal(boolean createFormId) {
        this.setPropertyBool(PROP_CREATE_FORM_ID, createFormId);
    }

    public String getFormId() {
        return this.getPropertyString(PROP_FORM_ID_NAME);
    }

    public void setFormId(String formId) {
        try {
            this.setStateChanging(true);
            this.setFormIdInternal(formId);
            if (this.isControlCreated()) {
                this.m_formIdField.setText(formId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setFormIdInternal(String formId) {
        this.setPropertyString(PROP_FORM_ID_NAME, formId);
    }

    public String getTargetPackage(String packageId) {
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            return (String)this.getProperty(PROP_TARGET_PACKAGE);
        }
        return DefaultTargetPackage.get(null, (String)packageId);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }
}

