/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields.buttonfield;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.form.field.ButtonFieldNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ButtonFieldNewWizardPage
extends AbstractWorkspaceWizardPage {
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private SiblingProposal m_sibling;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private final String m_readOnlySuffix;
    private IType m_createdField;

    public ButtonFieldNewWizardPage(IType declaringType) {
        this(declaringType, Texts.get((String)"NewButtonField"), Texts.get((String)"CreateANewButtonField"), "Button");
    }

    public ButtonFieldNewWizardPage(IType declaringType, String title, String message, String suffix) {
        super(ButtonFieldNewWizardPage.class.getName());
        this.m_readOnlySuffix = suffix;
        this.setTitle(title);
        this.setDescription(message);
        this.m_declaringType = declaringType;
        this.setSuperType(RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IButton", (IJavaProject)this.m_declaringType.getJavaProject()));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropLabel"));
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    ButtonFieldNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = ButtonFieldNewWizardPage.this.getNlsName();
                    ButtonFieldNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (ButtonFieldNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(ButtonFieldNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((CharSequence)ButtonFieldNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        ButtonFieldNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)ButtonFieldNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    ButtonFieldNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix(this.m_readOnlySuffix);
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeName = this.m_typeNameField.getText();
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ButtonFieldNewWizardPage.this.m_typeName = ButtonFieldNewWizardPage.this.m_typeNameField.getText();
                ButtonFieldNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_siblingField = this.getFieldToolkit().createFormFieldSiblingProposalField(parent, this.m_declaringType);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ButtonFieldNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                ButtonFieldNewWizardPage.this.pingStateChanging();
            }
        });
        if (this.m_sibling == null) {
            this.m_sibling = (SiblingProposal)this.m_siblingField.getSelectedProposal();
        } else {
            this.m_siblingField.acceptProposal(this.m_sibling);
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ButtonFieldNewOperation buttonFieldOp = new ButtonFieldNewOperation(this.getTypeName(), this.getDeclaringType(), true);
        buttonFieldOp.setNlsEntry(this.getNlsName());
        if (this.getSuperType() != null) {
            buttonFieldOp.setSuperTypeSignature(SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        }
        if (this.getSibling() == SiblingProposal.SIBLING_END || this.getSibling() == null) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCompositeField((IType)this.m_declaringType);
            buttonFieldOp.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_FORM_FIELD));
        } else {
            buttonFieldOp.setSibling(this.getSibling().getElement());
        }
        buttonFieldOp.run(monitor, workingCopyManager);
        this.m_createdField = buttonFieldOp.getCreatedButton();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        return ScoutUtility.validateFormFieldName((String)this.getTypeName(), (String)this.m_readOnlySuffix, (IType)this.m_declaringType);
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public IType getCreatedField() {
        return this.m_createdField;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
        this.pingStateChanging();
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

